/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.FileResourceCrawler;
import org.apache.tika.batch.fs.FSFileResource;

public class FSDirectoryCrawler
extends FileResourceCrawler {
    private final Path root;
    private final Path startDirectory;
    private final Comparator<Path> pathComparator = new FileNameComparator();
    private CRAWL_ORDER crawlOrder;

    public FSDirectoryCrawler(ArrayBlockingQueue<FileResource> fileQueue, int numConsumers, Path root, CRAWL_ORDER crawlOrder) {
        super(fileQueue, numConsumers);
        this.root = root;
        this.startDirectory = root;
        this.crawlOrder = crawlOrder;
        if (!Files.isDirectory(this.startDirectory, new LinkOption[0])) {
            throw new RuntimeException("Crawler couldn't find this directory:" + this.startDirectory.toAbsolutePath());
        }
    }

    public FSDirectoryCrawler(ArrayBlockingQueue<FileResource> fileQueue, int numConsumers, Path root, Path startDirectory, CRAWL_ORDER crawlOrder) {
        super(fileQueue, numConsumers);
        this.root = root;
        this.startDirectory = startDirectory;
        this.crawlOrder = crawlOrder;
        assert (startDirectory.toAbsolutePath().startsWith(root.toAbsolutePath()));
        if (!Files.isDirectory(startDirectory, new LinkOption[0])) {
            throw new RuntimeException("Crawler couldn't find this directory:" + startDirectory.toAbsolutePath());
        }
    }

    @Override
    public void start() throws InterruptedException {
        this.addFiles(this.startDirectory);
    }

    private void addFiles(Path directory) throws InterruptedException {
        if (directory == null) {
            LOG.warn("FSFileAdder asked to process null directory?!");
            return;
        }
        ArrayList<Path> files = new ArrayList<Path>();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(directory);){
            for (Path p : ds) {
                files.add(p);
            }
        }
        catch (IOException e) {
            LOG.warn("FSFileAdder couldn't read {}: {}", new Object[]{directory.toAbsolutePath(), e.getMessage(), e});
        }
        if (files.size() == 0) {
            LOG.info("Empty directory: {}", (Object)directory.toAbsolutePath());
            return;
        }
        if (this.crawlOrder == CRAWL_ORDER.RANDOM) {
            Collections.shuffle(files);
        } else if (this.crawlOrder == CRAWL_ORDER.SORTED) {
            Collections.sort(files, this.pathComparator);
        }
        int numFiles = 0;
        LinkedList<Path> directories = new LinkedList<Path>();
        for (Path f : files) {
            int added;
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("file adder interrupted");
            }
            if (!Files.isReadable(f)) {
                LOG.warn("Skipping -- {} -- file/directory is not readable", (Object)f.toAbsolutePath());
                continue;
            }
            if (Files.isDirectory(f, new LinkOption[0])) {
                directories.add(f);
                continue;
            }
            if (++numFiles == 1) {
                this.handleFirstFileInDirectory(f);
            }
            if ((added = this.tryToAdd(new FSFileResource(this.root, f))) == 2) {
                LOG.debug("crawler has hit a limit: {} : {}", (Object)f.toAbsolutePath(), (Object)added);
                return;
            }
            LOG.debug("trying to add: {} : {}", (Object)f.toAbsolutePath(), (Object)added);
        }
        for (Path f : directories) {
            this.addFiles(f);
        }
    }

    public void handleFirstFileInDirectory(Path f) {
    }

    private class FileNameComparator
    implements Comparator<Path> {
        private FileNameComparator() {
        }

        @Override
        public int compare(Path f1, Path f2) {
            if (f1 == null || f2 == null) {
                return 0;
            }
            return f1.getFileName().toString().compareTo(f2.getFileName().toString());
        }
    }

    public static enum CRAWL_ORDER {
        SORTED,
        RANDOM,
        OS_ORDER;

    }
}

