/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.emitter.fs;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.tika.config.Field;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.serialization.JsonMetadataList;
import org.apache.tika.pipes.emitter.AbstractEmitter;
import org.apache.tika.pipes.emitter.StreamEmitter;
import org.apache.tika.pipes.emitter.TikaEmitterException;

public class FileSystemEmitter
extends AbstractEmitter
implements StreamEmitter {
    private Path basePath = null;
    private String fileExtension = "json";
    private ON_EXISTS onExists = ON_EXISTS.EXCEPTION;

    @Override
    public void emit(String emitKey, List<Metadata> metadataList) throws IOException, TikaEmitterException {
        Path output;
        if (metadataList == null || metadataList.size() == 0) {
            throw new TikaEmitterException("metadata list must not be null or of size 0");
        }
        if (this.fileExtension != null && this.fileExtension.length() > 0) {
            emitKey = emitKey + "." + this.fileExtension;
        }
        if (!Files.isDirectory((output = this.basePath != null ? this.basePath.resolve(emitKey) : Paths.get(emitKey, new String[0])).getParent(), new LinkOption[0])) {
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(output, StandardCharsets.UTF_8, new OpenOption[0]);){
            JsonMetadataList.toJson(metadataList, writer);
        }
    }

    @Field
    public void setBasePath(String basePath) {
        this.basePath = Paths.get(basePath, new String[0]);
    }

    @Field
    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @Field
    public void setOnExists(String onExists) {
        switch (onExists) {
            case "skip": {
                this.onExists = ON_EXISTS.SKIP;
                break;
            }
            case "replace": {
                this.onExists = ON_EXISTS.REPLACE;
                break;
            }
            case "exception": {
                this.onExists = ON_EXISTS.EXCEPTION;
                break;
            }
            default: {
                throw new IllegalArgumentException("Don't understand '" + onExists + "'; must be one of: 'skip', 'replace', 'exception'");
            }
        }
    }

    @Override
    public void emit(String path, InputStream inputStream, Metadata userMetadata) throws IOException, TikaEmitterException {
        Path target = this.basePath.resolve(path);
        if (!Files.isDirectory(target.getParent(), new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
        }
        if (this.onExists == ON_EXISTS.REPLACE) {
            Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
        } else if (this.onExists == ON_EXISTS.EXCEPTION) {
            Files.copy(inputStream, target, new CopyOption[0]);
        } else if (this.onExists == ON_EXISTS.SKIP && !Files.isRegularFile(target, new LinkOption[0])) {
            try {
                Files.copy(inputStream, target, new CopyOption[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
    }

    static enum ON_EXISTS {
        SKIP,
        EXCEPTION,
        REPLACE;

    }
}

