/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.odf;

import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class NSNormalizerContentHandler
extends ContentHandlerDecorator {
    private static final String OLD_NS = "http://openoffice.org/2000/";
    private static final String NEW_NS = "urn:oasis:names:tc:opendocument:xmlns:";
    private static final String DTD_PUBLIC_ID = "-//OpenOffice.org//DTD OfficeDocument 1.0//EN";

    public NSNormalizerContentHandler(ContentHandler handler) {
        super(handler);
    }

    private String mapOldNS(String ns) {
        if (ns != null && ns.startsWith(OLD_NS)) {
            return NEW_NS + ns.substring(OLD_NS.length()) + ":1.0";
        }
        return ns;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        AttributesImpl natts = new AttributesImpl();
        for (int i = 0; i < atts.getLength(); ++i) {
            natts.addAttribute(this.mapOldNS(atts.getURI(i)), atts.getLocalName(i), atts.getQName(i), atts.getType(i), atts.getValue(i));
        }
        super.startElement(this.mapOldNS(namespaceURI), localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        super.endElement(this.mapOldNS(namespaceURI), localName, qName);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, this.mapOldNS(uri));
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        if (systemId != null && systemId.toLowerCase(Locale.ROOT).endsWith(".dtd") || DTD_PUBLIC_ID.equals(publicId)) {
            return new InputSource(new StringReader(""));
        }
        return super.resolveEntity(publicId, systemId);
    }
}

