/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.rarfile;

import com.github.junrar.io.Raw;
import com.github.junrar.rarfile.BlockHeader;
import com.github.junrar.rarfile.SubBlockHeaderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubBlockHeader
extends BlockHeader {
    private static final Logger logger = LoggerFactory.getLogger(SubBlockHeader.class);
    public static final short SubBlockHeaderSize = 3;
    private final short subType;
    private byte level;

    public SubBlockHeader(SubBlockHeader sb) {
        super(sb);
        this.subType = sb.getSubType().getSubblocktype();
        this.level = sb.getLevel();
    }

    public SubBlockHeader(BlockHeader bh, byte[] subblock) {
        super(bh);
        int position = 0;
        this.subType = Raw.readShortLittleEndian(subblock, position);
        this.level = (byte)(this.level | subblock[position += 2] & 0xFF);
    }

    public byte getLevel() {
        return this.level;
    }

    public SubBlockHeaderType getSubType() {
        return SubBlockHeaderType.findSubblockHeaderType(this.subType);
    }

    @Override
    public void print() {
        super.print();
        if (logger.isInfoEnabled()) {
            logger.info("subtype: {}", (Object)this.getSubType());
            logger.info("level: {}", (Object)this.level);
        }
    }
}

