/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WriteOutContentHandler
extends DefaultHandler {
    private final Writer writer;

    public WriteOutContentHandler(Writer writer) {
        this.writer = writer;
    }

    public WriteOutContentHandler(OutputStream stream) {
        this(new OutputStreamWriter(stream));
    }

    public WriteOutContentHandler() {
        this(new StringWriter());
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.writer.write(ch, start, length);
        }
        catch (IOException e) {
            throw new SAXException("Error writing out character content", e);
        }
    }

    public String toString() {
        return this.writer.toString();
    }
}

