/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

public abstract class PackageParser
implements Parser {
    private Parser parser;

    public Parser getParser() {
        Parser parser = this.parser;
        if (parser == null) {
            parser = new AutoDetectParser();
        }
        return parser;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    protected void parseEntry(InputStream stream, XHTMLContentHandler xhtml, Metadata metadata) throws IOException, SAXException {
        xhtml.startElement("div", "class", "package-entry");
        String name = metadata.get("resourceName");
        if (name != null) {
            xhtml.element("h1", name);
            xhtml.characters("\n");
        }
        try {
            this.getParser().parse((InputStream)new CloseShieldInputStream(stream), new BodyContentHandler(xhtml), metadata);
            xhtml.characters("\n");
        }
        catch (TikaException e) {
            // empty catch block
        }
        xhtml.endElement("div");
    }
}

