/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.pkg.PackageParser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class GzipParser
extends PackageParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        metadata.set("Content-Type", "application/x-gzip");
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        GZIPInputStream gzip = new GZIPInputStream((InputStream)new CloseShieldInputStream(stream));
        try {
            Metadata entrydata = new Metadata();
            String name = metadata.get("resourceName");
            if (name != null) {
                if (name.endsWith(".tgz")) {
                    name = name.substring(0, name.length() - 4) + ".tar";
                } else if (name.endsWith(".gz") || name.endsWith("-gz")) {
                    name = name.substring(0, name.length() - 3);
                }
                entrydata.set("resourceName", name);
            }
            this.parseEntry(gzip, xhtml, entrydata);
        }
        finally {
            ((InputStream)gzip).close();
        }
        xhtml.endDocument();
    }
}

