/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.opendocument;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.opendocument.OpenOfficeContentParser;
import org.apache.tika.parser.opendocument.OpenOfficeMetaParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OpenOfficeParser
implements Parser {
    private Parser meta = new OpenOfficeMetaParser();
    private Parser content = new OpenOfficeContentParser();

    public Parser getMetaParser() {
        return this.meta;
    }

    public void setMetaParser(Parser meta) {
        this.meta = meta;
    }

    public Parser getContentParser() {
        return this.content;
    }

    public void setContentParser(Parser content) {
        this.content = content;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        ZipInputStream zip = new ZipInputStream(stream);
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            if (entry.getName().equals("mimetype")) {
                String type = IOUtils.toString((InputStream)zip, (String)"UTF-8");
                metadata.set("Content-Type", type);
            } else if (entry.getName().equals("meta.xml")) {
                this.meta.parse(zip, new DefaultHandler(), metadata);
            } else if (entry.getName().equals("content.xml")) {
                this.content.parse(zip, handler, metadata);
            }
            entry = zip.getNextEntry();
        }
    }
}

