/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.audio;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MidiParser
implements Parser {
    private static HashMap<Float, String> divisionTypes = new HashMap();

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, metadata);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }

    public void parse(InputStream stream, Metadata metadata) throws IOException, TikaException {
        String type = metadata.get("Content-Type");
        if (type != null) {
            try {
                Sequence sequence = MidiSystem.getSequence(stream);
                metadata.set("tracks", Integer.toString(sequence.getTracks().length));
                metadata.set("patches", Integer.toString(sequence.getPatchList().length));
                metadata.set("divisionType", divisionTypes.get(Float.valueOf(sequence.getDivisionType())));
            }
            catch (InvalidMidiDataException e) {
                // empty catch block
            }
        }
    }

    static {
        divisionTypes.put(Float.valueOf(0.0f), "PRQ");
        divisionTypes.put(Float.valueOf(24.0f), "SMPTE_24");
        divisionTypes.put(Float.valueOf(25.0f), "SMPTE_25");
        divisionTypes.put(Float.valueOf(30.0f), "SMPTE_30");
        divisionTypes.put(Float.valueOf(29.97f), "SMPTE_30DROP");
    }
}

