/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.parser.CompositeParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AutoDetectParser
extends CompositeParser {
    private MimeTypes types;

    public AutoDetectParser() {
        try {
            this.setConfig(TikaConfig.getDefaultConfig());
        }
        catch (TikaException e) {
            throw new RuntimeException(e);
        }
    }

    public AutoDetectParser(TikaConfig config) {
        this.setConfig(config);
    }

    public void setConfig(TikaConfig config) {
        this.setParsers(config.getParsers());
        this.setMimeTypes(config.getMimeRepository());
    }

    public MimeTypes getMimeTypes() {
        return this.types;
    }

    public void setMimeTypes(MimeTypes types) {
        this.types = types;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        MimeType type = this.getMimeType(stream, metadata);
        metadata.set("Content-Type", type.getName());
        super.parse(stream, handler, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeType getMimeType(InputStream stream, Metadata metadata) throws IOException {
        MimeType type;
        stream.mark(this.types.getMinLength());
        try {
            byte[] prefix = this.getPrefix(stream, this.types.getMinLength());
            type = this.types.getMimeType(prefix);
            if (type != null) {
                MimeType mimeType = type;
                return mimeType;
            }
        }
        finally {
            stream.reset();
        }
        String resourceName = metadata.get("resourceName");
        if (resourceName != null && (type = this.types.getMimeType(resourceName)) != null) {
            return type;
        }
        String typename = metadata.get("Content-Type");
        if (typename != null) {
            try {
                return this.types.forName(typename);
            }
            catch (MimeTypeException e) {
                // empty catch block
            }
        }
        try {
            return this.types.forName("application/octet-stream");
        }
        catch (MimeTypeException e) {
            return null;
        }
    }

    private byte[] getPrefix(InputStream input, int length) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[Math.min(1024, length)];
        int n = input.read(buffer);
        while (n != -1) {
            output.write(buffer, 0, n);
            int remaining = length - output.size();
            if (remaining > 0) {
                n = input.read(buffer, 0, Math.min(buffer.length, remaining));
                continue;
            }
            n = -1;
        }
        return output.toByteArray();
    }
}

