/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.mime.Clause;
import org.apache.tika.mime.Magic;
import org.apache.tika.mime.MagicClause;
import org.apache.tika.mime.MagicMatch;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.Operator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

final class MimeTypesReader {
    private Log logger = null;
    private final MimeTypes types;

    MimeTypesReader(MimeTypes types) {
        this(types, null);
    }

    MimeTypesReader(MimeTypes types, Log logger) {
        this.types = types;
        this.logger = logger == null ? LogFactory.getLog(this.getClass()) : logger;
    }

    void read(String filepath) {
        this.read(MimeTypesReader.class.getClassLoader().getResourceAsStream(filepath));
    }

    void read(InputStream stream) {
        block2: {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(new InputSource(stream));
                this.read(document);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn((Object)(e.toString() + " while loading mime-types"));
            }
        }
    }

    void read(Document document) {
        Element element = document.getDocumentElement();
        if (element != null && element.getTagName().equals("mime-info")) {
            NodeList nodes = element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element child;
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || !(child = (Element)node).getTagName().equals("mime-type")) continue;
                this.readMimeType(child);
            }
        } else {
            this.logger.warn((Object)"Not a <mime-info/> configuration document");
        }
    }

    private void readMimeType(Element element) {
        String name = element.getAttribute("type");
        try {
            MimeType type = this.types.forName(name);
            NodeList nodes = element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element nodeElement = (Element)node;
                if (nodeElement.getTagName().equals("_comment")) {
                    type.setDescription(nodeElement.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeElement.getTagName().equals("glob")) {
                    this.types.addPattern(type, nodeElement.getAttribute("pattern"));
                    continue;
                }
                if (nodeElement.getTagName().equals("magic")) {
                    this.readMagic(nodeElement, type);
                    continue;
                }
                if (nodeElement.getTagName().equals("alias")) {
                    String alias = nodeElement.getAttribute("type");
                    try {
                        type.addAlias(alias);
                    }
                    catch (MimeTypeException e) {
                        this.logger.warn((Object)("Invalid media type alias: " + alias), (Throwable)e);
                    }
                    continue;
                }
                if (nodeElement.getTagName().equals("root-XML")) {
                    this.readRootXML(nodeElement, type);
                    continue;
                }
                if (!nodeElement.getTagName().equals("sub-class-of")) continue;
                String parent = nodeElement.getAttribute("type");
                try {
                    type.setSuperType(this.types.forName(parent));
                    continue;
                }
                catch (MimeTypeException e) {
                    this.logger.warn((Object)("Invalid parent type: " + parent), (Throwable)e);
                }
            }
            this.types.add(type);
        }
        catch (MimeTypeException e) {
            this.logger.warn((Object)("Invalid media type configuration entry: " + name), (Throwable)e);
        }
    }

    private void readMagic(Element element, MimeType mimeType) {
        Magic magic = null;
        try {
            magic = new Magic(Integer.parseInt(element.getAttribute("priority")));
        }
        catch (Exception e) {
            magic = new Magic();
        }
        magic.setType(mimeType);
        magic.setClause(this.readMatches(element));
        mimeType.addMagic(magic);
    }

    private Clause readMatches(Element element) {
        Clause sub = null;
        Clause prev = Clause.FALSE;
        Clause clause = null;
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(nodeElement = (Element)node).getTagName().equals("match")) continue;
            sub = this.readMatches(nodeElement);
            try {
                clause = sub != null ? new MagicClause(Operator.AND, this.readMatch(nodeElement), sub) : this.readMatch(nodeElement);
                clause = new MagicClause(Operator.OR, prev, clause);
                prev = clause;
                continue;
            }
            catch (MimeTypeException mte) {
                this.logger.warn((Object)(mte + " while reading magic-match [" + nodeElement + "], Ignoring!"));
            }
        }
        return clause;
    }

    private MagicMatch readMatch(Element element) throws MimeTypeException {
        String offset = null;
        String value = null;
        String mask = null;
        String type = null;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("offset")) {
                offset = attr.getValue();
                continue;
            }
            if (attr.getName().equals("type")) {
                type = attr.getValue();
                continue;
            }
            if (attr.getName().equals("value")) {
                value = attr.getValue();
                continue;
            }
            if (!attr.getName().equals("mask")) continue;
            mask = attr.getValue();
        }
        String[] offsets = offset.split(":");
        int offStart = 0;
        int offEnd = 0;
        try {
            offStart = Integer.parseInt(offsets[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            offEnd = Integer.parseInt(offsets[1]);
        }
        catch (Exception e) {
            // empty catch block
        }
        offEnd = Math.max(offStart, offEnd);
        return new MagicMatch(offStart, offEnd, type, mask, value);
    }

    private void readRootXML(Element element, MimeType mimeType) {
        mimeType.addRootXML(element.getAttribute("namespaceURI"), element.getAttribute("localName"));
    }
}

