/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.tika.mime.Magic;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.Patterns;

public final class MimeTypes {
    public static final String DEFAULT = "application/octet-stream";
    private final MimeType root;
    private final Map<String, MimeType> types = new HashMap<String, MimeType>();
    private Patterns patterns = new Patterns();
    private SortedSet<Magic> magics = new TreeSet<Magic>();
    private SortedSet<MimeType> xmls = new TreeSet<MimeType>();

    public MimeTypes() {
        this.root = new MimeType(this, DEFAULT);
        this.types.put(this.root.getName(), this.root);
    }

    public MimeType getMimeType(File file) {
        return this.getMimeType(file.getName());
    }

    public MimeType getMimeType(URL url) {
        return this.getMimeType(url.getPath());
    }

    public MimeType getMimeType(String name) {
        MimeType type = this.patterns.matches(name);
        if (type != null) {
            return type;
        }
        type = this.patterns.matches(name.toLowerCase());
        if (type != null) {
            return type;
        }
        return this.root;
    }

    public MimeType getMimeType(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Data is missing");
        }
        for (MimeType type : this.xmls) {
            if (!type.matchesXML(data)) continue;
            return type;
        }
        for (Magic magic : this.magics) {
            if (!magic.eval(data)) continue;
            return magic.getType();
        }
        return null;
    }

    public MimeType getMimeType(InputStream stream) throws IOException {
        return this.getMimeType(this.readMagicHeader(stream));
    }

    private byte[] readMagicHeader(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("InputStream is missing");
        }
        byte[] bytes = new byte[this.getMinLength()];
        int totalRead = 0;
        int lastRead = stream.read(bytes);
        while (lastRead != -1) {
            if ((totalRead += lastRead) == bytes.length) {
                return bytes;
            }
            lastRead = stream.read(bytes, totalRead, bytes.length - totalRead);
        }
        byte[] shorter = new byte[totalRead];
        System.arraycopy(bytes, 0, shorter, 0, totalRead);
        return shorter;
    }

    public String getType(String typeName, String url, byte[] data) {
        MimeType type = this.getMimeType(url, data);
        if (type == null && typeName != null) {
            try {
                type = this.forName(typeName);
            }
            catch (MimeTypeException e) {
                // empty catch block
            }
        }
        if (type == null) {
            type = this.root;
        }
        return type.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getType(URL url) throws IOException {
        InputStream stream = url.openStream();
        try {
            String string = this.getType(null, url.toString(), this.readMagicHeader(stream));
            return string;
        }
        finally {
            stream.close();
        }
    }

    public MimeType getMimeType(String name, byte[] data) {
        MimeType mimeType = this.getMimeType(data);
        if (mimeType == null) {
            mimeType = this.getMimeType(name);
        }
        return mimeType;
    }

    public MimeType getMimeType(String name, InputStream stream) throws IOException {
        return this.getMimeType(name, this.readMagicHeader(stream));
    }

    public synchronized MimeType forName(String name) throws MimeTypeException {
        if (MimeType.isValid(name)) {
            MimeType type = this.types.get(name = name.toLowerCase());
            if (type == null) {
                type = new MimeType(this, name);
                type.setSuperType(this.root);
                this.types.put(name, type);
            }
            return type;
        }
        throw new MimeTypeException("Invalid media type name: " + name);
    }

    synchronized void addAlias(MimeType type, String alias) throws MimeTypeException {
        if (this.types.containsKey(alias)) {
            throw new MimeTypeException("Media type alias already exists: " + alias);
        }
        this.types.put(alias, type);
    }

    public void addPattern(MimeType type, String pattern) throws MimeTypeException {
        this.patterns.add(pattern, type);
    }

    public int getMinLength() {
        return 1024;
    }

    void add(MimeType type) {
        if (type.hasMagic()) {
            this.magics.addAll(Arrays.asList(type.getMagics()));
        }
        if (type.hasRootXML()) {
            this.xmls.add(type);
        }
    }
}

