/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Arrays;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.apache.tika.gui.TikaGUI;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class TikaCLI {
    private Parser parser = new AutoDetectParser();
    private Metadata metadata;
    private ContentHandler handler = this.getXmlContentHandler();

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure((Appender)new WriterAppender((Layout)new SimpleLayout(), (OutputStream)System.err));
        Logger.getRootLogger().setLevel(Level.INFO);
        TikaCLI cli = new TikaCLI();
        for (int i = 0; i < args.length; ++i) {
            cli.process(args[i]);
        }
        if (args.length == 0) {
            cli.process("-");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String arg) throws Exception {
        if (arg.equals("-?") || arg.equals("--help")) {
            this.usage();
        } else if (arg.equals("-v") || arg.equals("--verbose")) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
        } else if (arg.equals("-g") || arg.equals("--gui")) {
            TikaGUI.main(new String[0]);
        } else if (arg.equals("-x") || arg.equals("--xml")) {
            this.handler = this.getXmlContentHandler();
        } else if (arg.equals("-h") || arg.equals("--html")) {
            this.handler = this.getHtmlContentHandler();
        } else if (arg.equals("-t") || arg.equals("--text")) {
            this.handler = this.getTextContentHandler();
        } else if (arg.equals("-m") || arg.equals("--metadata")) {
            this.handler = this.getMetadataContentHandler();
        } else {
            this.metadata = new Metadata();
            if (arg.equals("-")) {
                this.parser.parse(System.in, this.handler, this.metadata);
            } else {
                InputStream input;
                File file = new File(arg);
                if (file.isFile()) {
                    this.metadata.set("resourceName", file.getName());
                    input = new FileInputStream(file);
                } else {
                    int slash;
                    URL url = new URL(arg);
                    String path = url.getPath();
                    String name = path.substring((slash = path.lastIndexOf(47)) + 1);
                    if (name.length() > 0) {
                        this.metadata.set("resourceName", name);
                    }
                    input = url.openStream();
                }
                try {
                    this.parser.parse(input, this.handler, this.metadata);
                }
                finally {
                    ((InputStream)input).close();
                }
            }
        }
    }

    private void usage() {
        PrintStream out = System.out;
        out.println("usage: tika [option] file");
        out.println();
        out.println("Options:");
        out.println("    -? or --help       Print this usage message");
        out.println("    -v or --verbose    Print debug level messages");
        out.println("    -g or --gui        Start the Apache Tika GUI");
        out.println("    -x or --xml        Output XHTML content (default)");
        out.println("    -h or --html       Output HTML content");
        out.println("    -t or --text       Output plain text content");
        out.println("    -m or --metadata   Output only metadata");
        out.println();
        out.println("Description:");
        out.println("    Apache Tika will parse the file(s) specified on the");
        out.println("    command line and output the extracted text content");
        out.println("    or metadata to standard output.");
        out.println();
        out.println("    Instead of a file name you can also specify the URL");
        out.println("    of a document to be parsed.");
        out.println();
        out.println("    Use \"-\" as the file name to parse the standard");
        out.println("    input stream.");
        out.println();
        out.println("    Use the \"--gui\" (or \"-g\") option to start");
        out.println("    the Apache Tika GUI. You can drag and drop files");
        out.println("    from a normal file explorer to the GUI window to");
        out.println("    extract text content and metadata from the files.");
    }

    private ContentHandler getXmlContentHandler() throws TransformerConfigurationException {
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("method", "xml");
        handler.getTransformer().setOutputProperty("indent", "yes");
        handler.setResult(new StreamResult(System.out));
        return handler;
    }

    private ContentHandler getHtmlContentHandler() throws TransformerConfigurationException {
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("method", "html");
        handler.getTransformer().setOutputProperty("indent", "yes");
        handler.setResult(new StreamResult(System.out));
        return handler;
    }

    private ContentHandler getTextContentHandler() {
        return new BodyContentHandler(System.out);
    }

    private ContentHandler getMetadataContentHandler() {
        return new DefaultHandler(){

            public void endDocument() {
                Object[] names = TikaCLI.this.metadata.names();
                Arrays.sort(names);
                for (Object name : names) {
                    System.out.println((String)name + ": " + TikaCLI.this.metadata.get((String)name));
                }
            }
        };
    }
}

