/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.webresources.modules;

import com.github.sommeri.less4j.LessCompiler;
import java.util.List;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.internal.webresources.CSSMinimizer;
import org.apache.tapestry5.internal.webresources.CacheMode;
import org.apache.tapestry5.internal.webresources.CoffeeScriptCompiler;
import org.apache.tapestry5.internal.webresources.GoogleClosureMinimizer;
import org.apache.tapestry5.internal.webresources.LessResourceTransformer;
import org.apache.tapestry5.internal.webresources.ResourceTransformerFactory;
import org.apache.tapestry5.internal.webresources.ResourceTransformerFactoryImpl;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.Autobuild;
import org.apache.tapestry5.ioc.annotations.Contribute;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.FactoryDefaults;
import org.apache.tapestry5.ioc.services.SymbolProvider;
import org.apache.tapestry5.services.ObjectRenderer;
import org.apache.tapestry5.services.assets.ResourceMinimizer;
import org.apache.tapestry5.services.assets.ResourceTransformer;
import org.apache.tapestry5.services.assets.StreamableResourceSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebResourcesModule {
    public static void bind(ServiceBinder binder) {
        binder.bind(ResourceTransformerFactory.class, ResourceTransformerFactoryImpl.class);
    }

    @Contribute(value=SymbolProvider.class)
    @FactoryDefaults
    public static void setupDefaultCacheDirectory(MappedConfiguration<String, Object> configuration) {
        configuration.add((Object)"tapestry.compiled-asset-cache-dir", (Object)"${java.io.tmpdir}");
    }

    @Contribute(value=StreamableResourceSource.class)
    public static void provideCompilers(MappedConfiguration<String, ResourceTransformer> configuration, ResourceTransformerFactory factory, @Autobuild CoffeeScriptCompiler coffeeScriptCompiler) {
        configuration.add((Object)"coffee", (Object)factory.createCompiler("text/javascript", "CoffeeScript", "JavaScript", coffeeScriptCompiler, CacheMode.SINGLE_FILE));
        configuration.add((Object)"less", (Object)factory.createCompiler("text/css", "Less", "CSS", new LessResourceTransformer(), CacheMode.MULTIPLE_FILE));
    }

    @Contribute(value=ResourceMinimizer.class)
    @Primary
    public static void setupDefaultResourceMinimizers(MappedConfiguration<String, ResourceMinimizer> configuration) {
        configuration.addInstance((Object)"text/css", CSSMinimizer.class);
        configuration.addInstance((Object)"text/javascript", GoogleClosureMinimizer.class);
    }

    @Contribute(value=ObjectRenderer.class)
    @Primary
    public static void provideLessCompilerProblemRenderer(MappedConfiguration<Class, ObjectRenderer> configuration) {
        configuration.add(LessCompiler.Problem.class, (Object)new ObjectRenderer<LessCompiler.Problem>(){

            public void render(LessCompiler.Problem problem, MarkupWriter writer) {
                List strings = CollectionFactory.newList();
                if (InternalUtils.isNonBlank((String)problem.getMessage())) {
                    strings.add(problem.getMessage());
                }
                if (problem.getLine() > 0) {
                    strings.add("line " + problem.getLine());
                }
                if (problem.getCharacter() > 0) {
                    strings.add("position " + problem.getCharacter());
                }
                writer.write(InternalUtils.join((List)strings, (String)" - "));
            }
        });
    }
}

