/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.spring;

import java.util.List;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.annotations.Marker;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.ioc.services.ChainBuilder;
import org.apache.tapestry5.services.ApplicationInitializer;
import org.apache.tapestry5.services.ApplicationInitializerFilter;
import org.apache.tapestry5.services.Context;
import org.apache.tapestry5.spring.ApplicationContextCustomizer;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.core.SpringVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringModule {
    private final Logger logger;

    public SpringModule(Logger logger) {
        this.logger = logger;
    }

    public void contributeApplicationInitializer(OrderedConfiguration<ApplicationInitializerFilter> configuration, final ApplicationContext springContext) {
        ApplicationInitializerFilter filter = new ApplicationInitializerFilter(){

            public void initializeApplication(Context context, ApplicationInitializer initializer) {
                SpringModule.this.logger.info(String.format("Spring version %s with %,d defined beans.", SpringVersion.getVersion(), springContext.getBeanDefinitionCount()));
                initializer.initializeApplication(context);
            }
        };
        configuration.add("SpringContextInitialization", (Object)filter, new String[0]);
    }

    public static void contributeFactoryDefaults(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"tapestry.use-external-spring-context", (Object)"false");
    }

    @Marker(value={Primary.class})
    public static ApplicationContextCustomizer buildApplicationContextCustomizer(List<ApplicationContextCustomizer> configuration, ChainBuilder builder) {
        return (ApplicationContextCustomizer)builder.build(ApplicationContextCustomizer.class, configuration);
    }
}

