/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.spring;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ioc.AnnotationProvider;
import org.apache.tapestry.ioc.ObjectLocator;
import org.apache.tapestry.ioc.ObjectProvider;
import org.apache.tapestry.ioc.annotations.InjectService;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.spring.SpringBean;
import org.apache.tapestry.spring.SpringMessages;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringObjectProvider
implements ObjectProvider {
    private final Log _log;
    private final WebApplicationContext _context;
    private boolean _beansNamesLoaded = false;
    private final Map<String, String> _beanNames = CollectionFactory.newCaseInsensitiveMap();

    public SpringObjectProvider(Log log, @InjectService(value="WebApplicationContext") WebApplicationContext context) {
        this._log = log;
        this._context = context;
    }

    private synchronized void loadBeanNames() {
        if (this._beansNamesLoaded) {
            return;
        }
        for (String name : this._context.getBeanDefinitionNames()) {
            this._beanNames.put(name, name);
        }
        this._log.info((Object)SpringMessages.contextStartup(this._beanNames.keySet()));
        this._beansNamesLoaded = true;
    }

    public <T> T provide(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator) {
        SpringBean annotation = (SpringBean)annotationProvider.getAnnotation(SpringBean.class);
        if (annotation == null) {
            return null;
        }
        String beanName = annotation.value();
        this.loadBeanNames();
        String effectiveName = this._beanNames.containsKey(beanName) ? this._beanNames.get(beanName) : beanName;
        try {
            Object raw = this._context.getBean(effectiveName, objectType);
            return objectType.cast(raw);
        }
        catch (Exception ex) {
            throw new RuntimeException(SpringMessages.beanAccessFailure(effectiveName, objectType, ex), ex);
        }
    }
}

