/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.net.URL;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.AbstractResource;

public final class ClasspathResource
extends AbstractResource {
    private final ClassLoader classLoader;
    private URL url;
    private boolean urlResolved;

    public ClasspathResource(String path) {
        this(Thread.currentThread().getContextClassLoader(), path);
    }

    public ClasspathResource(ClassLoader classLoader, String path) {
        super(path);
        assert (classLoader != null);
        this.classLoader = classLoader;
    }

    @Override
    protected Resource newResource(String path) {
        return new ClasspathResource(this.classLoader, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL toURL() {
        try {
            this.acquireReadLock();
            if (!this.urlResolved) {
                this.resolveURL();
            }
            URL uRL = this.url;
            return uRL;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveURL() {
        try {
            this.upgradeReadLockToWriteLock();
            if (!this.urlResolved) {
                this.url = this.classLoader.getResource(this.getPath());
                this.validateURL(this.url);
                this.urlResolved = true;
            }
        }
        finally {
            this.downgradeWriteLockToReadLock();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ClasspathResource other = (ClasspathResource)obj;
        return other.classLoader == this.classLoader && other.getPath().equals(this.getPath());
    }

    public int hashCode() {
        return 0xE3 ^ this.getPath().hashCode();
    }

    public String toString() {
        return "classpath:" + this.getPath();
    }
}

