/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services.cron;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ParallelExecutor;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.apache.tapestry5.ioc.services.cron.PeriodicExecutor;
import org.apache.tapestry5.ioc.services.cron.PeriodicJob;
import org.apache.tapestry5.ioc.services.cron.Schedule;
import org.slf4j.Logger;

public class PeriodicExecutorImpl
implements PeriodicExecutor,
Runnable {
    private final ParallelExecutor parallelExecutor;
    private final Logger logger;
    private final List<Job> jobs = CollectionFactory.newList();
    private final Thread thread = new Thread((Runnable)this, "Tapestry PeriodicExecutor");
    private boolean shutdown;
    private static final long FIVE_MINUTES = 300000L;
    private final AtomicInteger jobIdAllocator = new AtomicInteger();

    public PeriodicExecutorImpl(ParallelExecutor parallelExecutor, Logger logger) {
        this.parallelExecutor = parallelExecutor;
        this.logger = logger;
    }

    @PostInjection
    public void start(RegistryShutdownHub hub) {
        hub.addRegistryShutdownListener(new Runnable(){

            @Override
            public void run() {
                PeriodicExecutorImpl.this.registryDidShutdown();
            }
        });
        this.thread.start();
    }

    synchronized void removeJob(Job job) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Removing " + job);
        }
        this.jobs.remove(job);
    }

    @Override
    public synchronized PeriodicJob addJob(Schedule schedule, String name, Runnable job) {
        assert (schedule != null);
        assert (name != null);
        assert (job != null);
        Job periodicJob = new Job(schedule, name, job);
        this.jobs.add(periodicJob);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Added " + periodicJob);
        }
        this.thread.interrupt();
        return periodicJob;
    }

    @Override
    public void run() {
        while (!this.isShutdown()) {
            long nextExecution = this.executeCurrentBatch();
            try {
                long delay = nextExecution - System.currentTimeMillis();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(String.format("Sleeping for %,d ms", delay));
                }
                if (delay <= 0L) continue;
                Thread.sleep(delay);
            }
            catch (InterruptedException ex) {
                this.logger.trace("Interrupted");
            }
        }
    }

    private synchronized boolean isShutdown() {
        return this.shutdown;
    }

    private synchronized void registryDidShutdown() {
        this.shutdown = true;
        this.thread.interrupt();
    }

    private synchronized long executeCurrentBatch() {
        long now = System.currentTimeMillis();
        long nextExecution = now + 300000L;
        for (Job job : this.jobs) {
            if (job.isExecuting()) continue;
            long jobNextExecution = job.getNextExecution();
            if (jobNextExecution <= now) {
                job.start();
                continue;
            }
            nextExecution = Math.min(nextExecution, jobNextExecution);
        }
        return nextExecution;
    }

    private class Job
    implements PeriodicJob,
    Invokable<Void> {
        final int jobId;
        private final Schedule schedule;
        private final String name;
        private final Runnable runnableJob;
        private boolean executing;
        private boolean canceled;
        private long nextExecution;

        public Job(Schedule schedule, String name, Runnable runnableJob) {
            this.jobId = PeriodicExecutorImpl.this.jobIdAllocator.incrementAndGet();
            this.schedule = schedule;
            this.name = name;
            this.runnableJob = runnableJob;
            this.nextExecution = schedule.firstExecution();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public synchronized long getNextExecution() {
            return this.nextExecution;
        }

        @Override
        public synchronized boolean isExecuting() {
            return this.executing;
        }

        @Override
        public synchronized boolean isCanceled() {
            return this.canceled;
        }

        @Override
        public synchronized void cancel() {
            this.canceled = true;
            if (!this.executing) {
                PeriodicExecutorImpl.this.removeJob(this);
            }
        }

        public synchronized String toString() {
            StringBuilder builder = new StringBuilder("PeriodicJob[#").append(this.jobId);
            builder.append(", (").append(this.name).append(")");
            if (this.executing) {
                builder.append(", executing");
            }
            if (this.canceled) {
                builder.append(", canceled");
            } else {
                builder.append(String.format(", next execution %Tk:%<TM:%<TS+%<TL", this.nextExecution));
            }
            return builder.append("]").toString();
        }

        synchronized void start() {
            this.executing = true;
            this.nextExecution = this.schedule.nextExecution(this.nextExecution);
            PeriodicExecutorImpl.this.parallelExecutor.invoke(this);
            if (PeriodicExecutorImpl.this.logger.isTraceEnabled()) {
                PeriodicExecutorImpl.this.logger.trace(this + " sent for execution");
            }
        }

        synchronized void cleanupAfterExecution() {
            if (PeriodicExecutorImpl.this.logger.isTraceEnabled()) {
                PeriodicExecutorImpl.this.logger.trace(this + " execution complete");
            }
            this.executing = false;
            if (this.canceled) {
                PeriodicExecutorImpl.this.removeJob(this);
            } else {
                PeriodicExecutorImpl.this.thread.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void invoke() {
            if (PeriodicExecutorImpl.this.logger.isDebugEnabled()) {
                PeriodicExecutorImpl.this.logger.debug(String.format("Executing job #%d (%s)", this.jobId, this.name));
            }
            try {
                this.runnableJob.run();
            }
            finally {
                this.cleanupAfterExecution();
            }
            return null;
        }
    }
}

