/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.List;
import org.apache.tapestry5.ioc.internal.util.OneShotLock;
import org.apache.tapestry5.ioc.util.ExceptionUtils;
import org.slf4j.Logger;

public class RegistryStartup
implements Runnable {
    private final Logger logger;
    private final List<Runnable> configuration;
    private final OneShotLock lock = new OneShotLock();

    public RegistryStartup(Logger logger, List<Runnable> configuration) {
        this.logger = logger;
        this.configuration = configuration;
    }

    @Override
    public void run() {
        this.lock.lock();
        for (Runnable r : this.configuration) {
            try {
                r.run();
            }
            catch (RuntimeException ex) {
                this.logger.error(String.format("An exception occurred during startup: %s", ExceptionUtils.toMessage(ex)), (Throwable)ex);
            }
        }
        this.configuration.clear();
    }
}

