/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.PerThreadValue;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.apache.tapestry5.ioc.services.ThreadCleanupListener;
import org.slf4j.Logger;

public class PerthreadManagerImpl
implements PerthreadManager {
    private final PerThreadValue<List<Runnable>> callbacksValue;
    private final Logger logger;
    private final MapHolder holder = new MapHolder();
    private final AtomicInteger uuidGenerator = new AtomicInteger();
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private static Object NULL_VALUE = new Object();

    public PerthreadManagerImpl(Logger logger) {
        this.logger = logger;
        this.callbacksValue = this.createValue();
    }

    public void registerForShutdown(RegistryShutdownHub hub) {
        hub.addRegistryShutdownListener(new Runnable(){

            @Override
            public void run() {
                PerthreadManagerImpl.this.cleanup();
                PerthreadManagerImpl.this.shutdown.set(true);
            }
        });
    }

    private Map getPerthreadMap() {
        if (this.shutdown.get()) {
            return CollectionFactory.newMap();
        }
        return (Map)this.holder.get();
    }

    private List<Runnable> getCallbacks() {
        List<Runnable> result = this.callbacksValue.get();
        if (result == null) {
            result = CollectionFactory.newList();
            this.callbacksValue.set(result);
        }
        return result;
    }

    @Override
    public void addThreadCleanupListener(final ThreadCleanupListener listener) {
        assert (listener != null);
        this.addThreadCleanupCallback(new Runnable(){

            @Override
            public void run() {
                listener.threadDidCleanup();
            }
        });
    }

    @Override
    public void addThreadCleanupCallback(Runnable callback) {
        assert (callback != null);
        this.getCallbacks().add(callback);
    }

    @Override
    public void cleanup() {
        List<Runnable> callbacks = this.getCallbacks();
        this.callbacksValue.set(null);
        for (Runnable callback : callbacks) {
            try {
                callback.run();
            }
            catch (Exception ex) {
                this.logger.warn(String.format("Error invoking callback %s: %s", callback, ex), (Throwable)ex);
            }
        }
        this.holder.remove();
    }

    <T> ObjectCreator<T> createValue(final Object key, final ObjectCreator<T> delegate) {
        return new ObjectCreator<T>(){

            @Override
            public T createObject() {
                Map map = PerthreadManagerImpl.this.getPerthreadMap();
                Object storedValue = map.get(key);
                if (storedValue != null) {
                    return storedValue == NULL_VALUE ? null : (Object)storedValue;
                }
                Object newValue = delegate.createObject();
                map.put(key, newValue == null ? NULL_VALUE : newValue);
                return newValue;
            }
        };
    }

    @Override
    public <T> ObjectCreator<T> createValue(ObjectCreator<T> delegate) {
        return this.createValue(this.uuidGenerator.getAndIncrement(), delegate);
    }

    <T> PerThreadValue<T> createValue(final Object key) {
        return new PerThreadValue<T>(){

            @Override
            public T get() {
                return this.get(null);
            }

            @Override
            public T get(T defaultValue) {
                Map map = PerthreadManagerImpl.this.getPerthreadMap();
                Object storedValue = map.get(key);
                if (storedValue == null) {
                    return defaultValue;
                }
                if (storedValue == NULL_VALUE) {
                    return null;
                }
                return storedValue;
            }

            @Override
            public T set(T newValue) {
                PerthreadManagerImpl.this.getPerthreadMap().put(key, newValue == null ? NULL_VALUE : newValue);
                return newValue;
            }

            @Override
            public boolean exists() {
                return PerthreadManagerImpl.this.getPerthreadMap().containsKey(key);
            }
        };
    }

    @Override
    public <T> PerThreadValue<T> createValue() {
        return this.createValue(this.uuidGenerator.getAndIncrement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Runnable runnable) {
        assert (runnable != null);
        try {
            runnable.run();
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invoke(Invokable<T> invokable) {
        try {
            T t = invokable.invoke();
            return t;
        }
        finally {
            this.cleanup();
        }
    }

    private static class MapHolder
    extends ThreadLocal<Map> {
        private MapHolder() {
        }

        @Override
        protected Map initialValue() {
            return CollectionFactory.newMap();
        }
    }
}

