/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ServiceLifecycle;
import org.apache.tapestry5.ioc.ServiceResources;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;

public class PerThreadServiceLifecycle
implements ServiceLifecycle {
    private final PerthreadManager perthreadManager;
    private final PlasticProxyFactory proxyFactory;

    public PerThreadServiceLifecycle(@Builtin PerthreadManager perthreadManager, @Builtin PlasticProxyFactory proxyFactory) {
        this.perthreadManager = perthreadManager;
        this.proxyFactory = proxyFactory;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public Object createService(ServiceResources resources, ObjectCreator creator) {
        ObjectCreator perThreadCreator = this.perthreadManager.createValue(creator);
        Class serviceInterface = resources.getServiceInterface();
        return this.proxyFactory.createProxy(serviceInterface, perThreadCreator, String.format("<PerThread Proxy for %s(%s)>", resources.getServiceId(), serviceInterface.getName()));
    }
}

