/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.util.Map;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.def.ContributionDef;
import org.apache.tapestry5.ioc.internal.AbstractConfigurationImpl;
import org.apache.tapestry5.ioc.internal.OrderedConfigurationOverride;
import org.apache.tapestry5.ioc.internal.TypeCoercerProxy;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.Orderer;

public class ValidatingOrderedConfigurationWrapper<T>
extends AbstractConfigurationImpl<T>
implements OrderedConfiguration<T> {
    private final TypeCoercerProxy typeCoercer;
    private final Orderer<T> orderer;
    private final Class<T> expectedType;
    private final Map<String, OrderedConfigurationOverride<T>> overrides;
    private final ContributionDef contribDef;
    private String priorId;

    public ValidatingOrderedConfigurationWrapper(Class<T> expectedType, ObjectLocator locator, TypeCoercerProxy typeCoercer, Orderer<T> orderer, Map<String, OrderedConfigurationOverride<T>> overrides, ContributionDef contribDef) {
        super(expectedType, locator);
        this.typeCoercer = typeCoercer;
        this.orderer = orderer;
        this.overrides = overrides;
        this.contribDef = contribDef;
        this.expectedType = expectedType;
    }

    @Override
    public void add(String id, T object, String ... constraints) {
        Object coerced;
        Object t = coerced = object == null ? null : (Object)this.typeCoercer.coerce(object, this.expectedType);
        if (constraints.length == 0 && this.priorId != null) {
            constraints = new String[]{"after:" + this.priorId};
        }
        this.orderer.add(id, coerced, constraints);
        this.priorId = id;
    }

    @Override
    public void override(String id, T object, String ... constraints) {
        assert (InternalUtils.isNonBlank(id));
        Object coerced = object == null ? null : (Object)this.typeCoercer.coerce(object, this.expectedType);
        OrderedConfigurationOverride<T> existing = this.overrides.get(id);
        if (existing != null) {
            throw new IllegalArgumentException(String.format("Contribution '%s' has already been overridden (by %s).", id, existing.getContribDef()));
        }
        this.overrides.put(id, new OrderedConfigurationOverride<Object>((Orderer<Object>)this.orderer, id, coerced, constraints, this.contribDef));
    }

    @Override
    public void addInstance(String id, Class<? extends T> clazz, String ... constraints) {
        this.add(id, this.instantiate(clazz), constraints);
    }

    @Override
    public void overrideInstance(String id, Class<? extends T> clazz, String ... constraints) {
        this.override(id, this.instantiate(clazz), constraints);
    }
}

