/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.util.Collection;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.internal.AbstractConfigurationImpl;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.apache.tapestry5.ioc.internal.TypeCoercerProxy;

public class ValidatingConfigurationWrapper<T>
extends AbstractConfigurationImpl<T>
implements Configuration<T> {
    private final TypeCoercerProxy typeCoercer;
    private final String serviceId;
    private final Class<T> expectedType;
    private final Collection<T> collection;

    public ValidatingConfigurationWrapper(Class<T> expectedType, ObjectLocator locator, TypeCoercerProxy typeCoercer, Collection<T> collection, String serviceId) {
        super(expectedType, locator);
        this.typeCoercer = typeCoercer;
        this.collection = collection;
        this.serviceId = serviceId;
        this.expectedType = expectedType;
    }

    @Override
    public void add(T object) {
        if (object == null) {
            throw new NullPointerException(IOCMessages.contributionWasNull(this.serviceId));
        }
        T coerced = this.typeCoercer.coerce(object, this.expectedType);
        this.collection.add(coerced);
    }

    @Override
    public void addInstance(Class<? extends T> clazz) {
        this.add(this.instantiate(clazz));
    }
}

