/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.tapestry5.ioc.ModuleBuilderSource;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.def.StartupDef;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.MapInjectionResources;
import org.slf4j.Logger;

public class StartupDefImpl
implements StartupDef {
    private final Method startupMethod;

    public StartupDefImpl(Method contributorMethod) {
        this.startupMethod = contributorMethod;
    }

    @Override
    public void invoke(final ModuleBuilderSource moduleBuilderSource, final OperationTracker tracker, final ObjectLocator locator, final Logger logger) {
        tracker.run(String.format("Invoking startup method %s.", InternalUtils.asString(this.startupMethod)), new Runnable(){

            @Override
            public void run() {
                Map<Class, Object> resourceMap = CollectionFactory.newMap();
                resourceMap.put(ObjectLocator.class, locator);
                resourceMap.put(Logger.class, logger);
                MapInjectionResources injectionResources = new MapInjectionResources(resourceMap);
                Throwable fail = null;
                Object moduleInstance = InternalUtils.isStatic(StartupDefImpl.this.startupMethod) ? null : moduleBuilderSource.getModuleBuilder();
                try {
                    ObjectCreator[] parameters = InternalUtils.calculateParametersForMethod(StartupDefImpl.this.startupMethod, locator, injectionResources, tracker);
                    StartupDefImpl.this.startupMethod.invoke(moduleInstance, InternalUtils.realizeObjects(parameters));
                }
                catch (InvocationTargetException ex) {
                    fail = ex.getTargetException();
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    fail = ex;
                }
                if (fail != null) {
                    throw new RuntimeException(fail);
                }
            }
        });
    }
}

