/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.ioc.AdvisorDef;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.IOOperation;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.LoggerSource;
import org.apache.tapestry5.ioc.ModuleBuilderSource;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.ObjectProvider;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.Registry;
import org.apache.tapestry5.ioc.ServiceAdvisor;
import org.apache.tapestry5.ioc.ServiceBuilderResources;
import org.apache.tapestry5.ioc.ServiceDecorator;
import org.apache.tapestry5.ioc.ServiceLifecycle;
import org.apache.tapestry5.ioc.ServiceLifecycle2;
import org.apache.tapestry5.ioc.annotations.Local;
import org.apache.tapestry5.ioc.def.ContributionDef;
import org.apache.tapestry5.ioc.def.ContributionDef2;
import org.apache.tapestry5.ioc.def.ContributionDef3;
import org.apache.tapestry5.ioc.def.DecoratorDef;
import org.apache.tapestry5.ioc.def.ModuleDef;
import org.apache.tapestry5.ioc.def.ModuleDef2;
import org.apache.tapestry5.ioc.def.ServiceDef;
import org.apache.tapestry5.ioc.def.ServiceDef2;
import org.apache.tapestry5.ioc.def.ServiceDef3;
import org.apache.tapestry5.ioc.def.StartupDef;
import org.apache.tapestry5.ioc.internal.EagerLoadServiceProxy;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.apache.tapestry5.ioc.internal.InternalRegistry;
import org.apache.tapestry5.ioc.internal.MappedConfigurationOverride;
import org.apache.tapestry5.ioc.internal.Module;
import org.apache.tapestry5.ioc.internal.ModuleImpl;
import org.apache.tapestry5.ioc.internal.NullAnnotationProvider;
import org.apache.tapestry5.ioc.internal.OrderedConfigurationOverride;
import org.apache.tapestry5.ioc.internal.ReloadableObjectCreator;
import org.apache.tapestry5.ioc.internal.SerializationSupport;
import org.apache.tapestry5.ioc.internal.ServiceActivityTracker;
import org.apache.tapestry5.ioc.internal.ServiceActivityTrackerImpl;
import org.apache.tapestry5.ioc.internal.ServiceDefImpl;
import org.apache.tapestry5.ioc.internal.ServiceProxyProvider;
import org.apache.tapestry5.ioc.internal.ServiceResourcesImpl;
import org.apache.tapestry5.ioc.internal.SingletonServiceLifecycle;
import org.apache.tapestry5.ioc.internal.TypeCoercerProxy;
import org.apache.tapestry5.ioc.internal.TypeCoercerProxyImpl;
import org.apache.tapestry5.ioc.internal.ValidatingConfigurationWrapper;
import org.apache.tapestry5.ioc.internal.ValidatingMappedConfigurationWrapper;
import org.apache.tapestry5.ioc.internal.ValidatingOrderedConfigurationWrapper;
import org.apache.tapestry5.ioc.internal.services.PerthreadManagerImpl;
import org.apache.tapestry5.ioc.internal.services.RegistryShutdownHubImpl;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.JDKUtils;
import org.apache.tapestry5.ioc.internal.util.MapInjectionResources;
import org.apache.tapestry5.ioc.internal.util.OneShotLock;
import org.apache.tapestry5.ioc.internal.util.Orderer;
import org.apache.tapestry5.ioc.modules.TapestryIOCModule;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.MasterObjectProvider;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.apache.tapestry5.ioc.services.ServiceActivityScoreboard;
import org.apache.tapestry5.ioc.services.ServiceConfigurationListener;
import org.apache.tapestry5.ioc.services.ServiceConfigurationListenerHub;
import org.apache.tapestry5.ioc.services.ServiceLifecycleSource;
import org.apache.tapestry5.ioc.services.Status;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.ioc.util.AvailableValues;
import org.apache.tapestry5.ioc.util.UnknownValueException;
import org.apache.tapestry5.services.UpdateListenerHub;
import org.slf4j.Logger;

public class RegistryImpl
implements Registry,
InternalRegistry,
ServiceProxyProvider {
    private static final String SYMBOL_SOURCE_SERVICE_ID = "SymbolSource";
    private static final String REGISTRY_SHUTDOWN_HUB_SERVICE_ID = "RegistryShutdownHub";
    static final String PERTHREAD_MANAGER_SERVICE_ID = "PerthreadManager";
    private static final String SERVICE_ACTIVITY_SCOREBOARD_SERVICE_ID = "ServiceActivityScoreboard";
    private static final Set<Class> BUILTIN = CollectionFactory.newSet();
    static final String PLASTIC_PROXY_FACTORY_SERVICE_ID = "PlasticProxyFactory";
    static final String LOGGER_SOURCE_SERVICE_ID = "LoggerSource";
    private final OneShotLock lock = new OneShotLock();
    private final OneShotLock eagerLoadLock = new OneShotLock();
    private final Map<String, Object> builtinServices = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, Class> builtinTypes = CollectionFactory.newCaseInsensitiveMap();
    private final RegistryShutdownHubImpl registryShutdownHub;
    private final LoggerSource loggerSource;
    private final Map<String, Module> serviceIdToModule = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, ServiceLifecycle2> lifecycles = CollectionFactory.newCaseInsensitiveMap();
    private final PerthreadManager perthreadManager;
    private final PlasticProxyFactory proxyFactory;
    private final ServiceActivityTracker tracker;
    private SymbolSource symbolSource;
    private final Map<Module, Set<ServiceDef2>> moduleToServiceDefs = CollectionFactory.newMap();
    private final Map<Class, List<ServiceDef2>> markerToServiceDef = CollectionFactory.newMap();
    private final Set<ServiceDef2> allServiceDefs = CollectionFactory.newSet();
    private final OperationTracker operationTracker;
    private final TypeCoercerProxy typeCoercerProxy = new TypeCoercerProxyImpl(this);
    private final Map<Class<? extends Annotation>, Annotation> cachedAnnotationProxies = CollectionFactory.newConcurrentMap();
    private final Set<Runnable> startups = CollectionFactory.newSet();
    private DelegatingServiceConfigurationListener serviceConfigurationListener;

    public RegistryImpl(Collection<ModuleDef2> moduleDefs, PlasticProxyFactory proxyFactory, LoggerSource loggerSource, OperationTracker operationTracker) {
        assert (moduleDefs != null);
        assert (proxyFactory != null);
        assert (loggerSource != null);
        assert (operationTracker != null);
        this.loggerSource = loggerSource;
        this.operationTracker = operationTracker;
        this.proxyFactory = proxyFactory;
        this.serviceConfigurationListener = new DelegatingServiceConfigurationListener(this.loggerForBuiltinService(ServiceConfigurationListener.class.getSimpleName()));
        Logger logger = this.loggerForBuiltinService(PERTHREAD_MANAGER_SERVICE_ID);
        PerthreadManagerImpl ptmImpl = new PerthreadManagerImpl(logger);
        this.perthreadManager = ptmImpl;
        final ServiceActivityTrackerImpl scoreboardAndTracker = new ServiceActivityTrackerImpl(this.perthreadManager);
        this.tracker = scoreboardAndTracker;
        logger = this.loggerForBuiltinService(REGISTRY_SHUTDOWN_HUB_SERVICE_ID);
        this.registryShutdownHub = new RegistryShutdownHubImpl(logger);
        ptmImpl.registerForShutdown(this.registryShutdownHub);
        this.lifecycles.put("singleton", new SingletonServiceLifecycle());
        this.registryShutdownHub.addRegistryShutdownListener(new Runnable(){

            @Override
            public void run() {
                scoreboardAndTracker.shutdown();
            }
        });
        for (ModuleDef2 def : moduleDefs) {
            logger = this.loggerSource.getLogger(def.getLoggerName());
            ModuleImpl module = new ModuleImpl(this, this.tracker, def, proxyFactory, logger);
            Set moduleServiceDefs = CollectionFactory.newSet();
            for (String serviceId : def.getServiceIds()) {
                ServiceDef3 serviceDef = module.getServiceDef(serviceId);
                moduleServiceDefs.add(serviceDef);
                this.allServiceDefs.add(serviceDef);
                Module existing = this.serviceIdToModule.get(serviceId);
                if (existing != null) {
                    throw new RuntimeException(IOCMessages.serviceIdConflict(serviceId, existing.getServiceDef(serviceId), serviceDef));
                }
                this.serviceIdToModule.put(serviceId, module);
                this.tracker.define(serviceDef, Status.DEFINED);
                for (Class marker : serviceDef.getMarkers()) {
                    InternalUtils.addToMapList(this.markerToServiceDef, marker, serviceDef);
                }
            }
            this.moduleToServiceDefs.put(module, moduleServiceDefs);
            this.addStartupsInModule(def, module, logger);
        }
        this.addBuiltin(SERVICE_ACTIVITY_SCOREBOARD_SERVICE_ID, ServiceActivityScoreboard.class, scoreboardAndTracker);
        this.addBuiltin(LOGGER_SOURCE_SERVICE_ID, LoggerSource.class, this.loggerSource);
        this.addBuiltin(PERTHREAD_MANAGER_SERVICE_ID, PerthreadManager.class, this.perthreadManager);
        this.addBuiltin(REGISTRY_SHUTDOWN_HUB_SERVICE_ID, RegistryShutdownHub.class, this.registryShutdownHub);
        this.addBuiltin(PLASTIC_PROXY_FACTORY_SERVICE_ID, PlasticProxyFactory.class, proxyFactory);
        this.validateContributeDefs(moduleDefs);
        this.serviceConfigurationListener.setDelegates(this.getService(ServiceConfigurationListenerHub.class).getListeners());
        scoreboardAndTracker.startup();
        SerializationSupport.setProvider(this);
    }

    private void addStartupsInModule(ModuleDef2 def, final Module module, final Logger logger) {
        for (final StartupDef startup : def.getStartups()) {
            this.startups.add(new Runnable(){

                @Override
                public void run() {
                    startup.invoke(module, RegistryImpl.this, RegistryImpl.this, logger);
                }
            });
        }
    }

    private void validateContributeDefs(Collection<ModuleDef2> moduleDefs) {
        for (ModuleDef2 module : moduleDefs) {
            Set<ContributionDef> contributionDefs = module.getContributionDefs();
            for (ContributionDef cd : contributionDefs) {
                String serviceId = cd.getServiceId();
                ContributionDef3 cd3 = InternalUtils.toContributionDef3(cd);
                if (cd3.isOptional()) continue;
                if (cd3.getServiceId() != null) {
                    if (this.serviceIdToModule.containsKey(serviceId)) continue;
                    throw new IllegalArgumentException(IOCMessages.contributionForNonexistentService(cd));
                }
                if (this.isContributionForExistentService(module, cd3)) continue;
                throw new IllegalArgumentException(IOCMessages.contributionForUnqualifiedService(cd3));
            }
        }
    }

    private boolean isContributionForExistentService(ModuleDef moduleDef, final ContributionDef2 cd) {
        final HashSet<Class> contributionMarkers = new HashSet<Class>(cd.getMarkers());
        boolean localOnly = contributionMarkers.contains(Local.class);
        Flow serviceDefs = localOnly ? this.getLocalServiceDefs(moduleDef) : F.flow(this.allServiceDefs);
        contributionMarkers.retainAll(this.getMarkerAnnotations());
        contributionMarkers.remove(Local.class);
        Flow filtered = (Flow)serviceDefs.filter(F.and((Predicate[])new Predicate[]{new Predicate<ServiceDef2>(){

            public boolean accept(ServiceDef2 object) {
                return object.getServiceInterface().equals(cd.getServiceInterface());
            }
        }, new Predicate<ServiceDef2>(){

            public boolean accept(ServiceDef2 serviceDef) {
                return serviceDef.getMarkers().containsAll(contributionMarkers);
            }
        }}));
        return !filtered.isEmpty();
    }

    private Flow<ServiceDef2> getLocalServiceDefs(final ModuleDef moduleDef) {
        return F.flow(moduleDef.getServiceIds()).map((Mapper)new Mapper<String, ServiceDef2>(){

            public ServiceDef2 map(String value) {
                return InternalUtils.toServiceDef2(moduleDef.getServiceDef(value));
            }
        });
    }

    @Override
    public void performRegistryStartup() {
        if (JDKUtils.JDK_1_5) {
            throw new RuntimeException("Your JDK version is too old. Tapestry requires Java 1.6 or newer since version 5.4.");
        }
        this.eagerLoadLock.lock();
        List<EagerLoadServiceProxy> proxies = CollectionFactory.newList();
        for (Module m : this.moduleToServiceDefs.keySet()) {
            m.collectEagerLoadServices(proxies);
        }
        for (EagerLoadServiceProxy proxy : proxies) {
            proxy.eagerLoadService();
        }
        for (Runnable startup : this.startups) {
            startup.run();
        }
        this.startups.clear();
        this.getService("RegistryStartup", Runnable.class).run();
        this.cleanupThread();
    }

    @Override
    public Logger getServiceLogger(String serviceId) {
        Module module = this.serviceIdToModule.get(serviceId);
        assert (module != null);
        return this.loggerSource.getLogger(module.getLoggerName() + "." + serviceId);
    }

    private Logger loggerForBuiltinService(String serviceId) {
        return this.loggerSource.getLogger(TapestryIOCModule.class + "." + serviceId);
    }

    private <T> void addBuiltin(final String serviceId, final Class<T> serviceInterface, T service) {
        this.builtinTypes.put(serviceId, serviceInterface);
        this.builtinServices.put(serviceId, service);
        ServiceDef2 serviceDef = new ServiceDef2(){

            @Override
            public ObjectCreator createServiceCreator(ServiceBuilderResources resources) {
                return null;
            }

            @Override
            public Set<Class> getMarkers() {
                return BUILTIN;
            }

            @Override
            public String getServiceId() {
                return serviceId;
            }

            @Override
            public Class getServiceInterface() {
                return serviceInterface;
            }

            @Override
            public String getServiceScope() {
                return "singleton";
            }

            @Override
            public boolean isEagerLoad() {
                return false;
            }

            @Override
            public boolean isPreventDecoration() {
                return true;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (serviceId == null ? 0 : serviceId.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof ServiceDefImpl)) {
                    return false;
                }
                ServiceDef other = (ServiceDef)obj;
                return !(serviceId == null ? other.getServiceId() != null : !serviceId.equals(other.getServiceId()));
            }
        };
        for (Class marker : serviceDef.getMarkers()) {
            InternalUtils.addToMapList(this.markerToServiceDef, marker, serviceDef);
            this.allServiceDefs.add(serviceDef);
        }
        this.tracker.define(serviceDef, Status.BUILTIN);
    }

    @Override
    public synchronized void shutdown() {
        this.lock.lock();
        this.registryShutdownHub.fireRegistryDidShutdown();
        SerializationSupport.clearProvider(this);
    }

    @Override
    public <T> T getService(String serviceId, Class<T> serviceInterface) {
        this.lock.check();
        T result = this.checkForBuiltinService(serviceId, serviceInterface);
        if (result != null) {
            return result;
        }
        Module containingModule = this.locateModuleForService(serviceId);
        return containingModule.getService(serviceId, serviceInterface);
    }

    private <T> T checkForBuiltinService(String serviceId, Class<T> serviceInterface) {
        Object service = this.builtinServices.get(serviceId);
        if (service == null) {
            return null;
        }
        try {
            return serviceInterface.cast(service);
        }
        catch (ClassCastException ex) {
            throw new RuntimeException(IOCMessages.serviceWrongInterface(serviceId, this.builtinTypes.get(serviceId), serviceInterface));
        }
    }

    @Override
    public void cleanupThread() {
        this.lock.check();
        this.perthreadManager.cleanup();
    }

    private Module locateModuleForService(String serviceId) {
        Module module = this.serviceIdToModule.get(serviceId);
        if (module == null) {
            throw new UnknownValueException(String.format("Service id '%s' is not defined by any module.", serviceId), new AvailableValues("Defined service ids", this.serviceIdToModule));
        }
        return module;
    }

    @Override
    public <T> Collection<T> getUnorderedConfiguration(ServiceDef3 serviceDef, Class<T> objectType) {
        this.lock.check();
        List result = CollectionFactory.newList();
        for (Module m : this.moduleToServiceDefs.keySet()) {
            this.addToUnorderedConfiguration(result, objectType, serviceDef, m);
        }
        if (!this.isServiceConfigurationListenerServiceDef(serviceDef)) {
            this.serviceConfigurationListener.onUnorderedConfiguration(serviceDef, result);
        }
        return result;
    }

    @Override
    public <T> List<T> getOrderedConfiguration(ServiceDef3 serviceDef, Class<T> objectType) {
        this.lock.check();
        String serviceId = serviceDef.getServiceId();
        Logger logger = this.getServiceLogger(serviceId);
        Orderer<7> orderer = new Orderer<7>(logger);
        Map<String, OrderedConfigurationOverride<T>> overrides = CollectionFactory.newCaseInsensitiveMap();
        ArrayList<Module> modules = new ArrayList<Module>(this.moduleToServiceDefs.keySet());
        Collections.sort(modules, new ModuleComparator());
        for (Module m : modules) {
            this.addToOrderedConfiguration(orderer, overrides, objectType, serviceDef, m);
        }
        if (serviceId.equals("MasterObjectProvider")) {
            ObjectProvider contribution = new ObjectProvider(){

                @Override
                public <T> T provide(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator) {
                    return (T)RegistryImpl.this.findServiceByMarkerAndType(objectType, annotationProvider, null);
                }
            };
            orderer.add("ServiceByMarker", contribution, new String[0]);
        }
        for (OrderedConfigurationOverride override : overrides.values()) {
            override.apply();
        }
        List result = orderer.getOrdered();
        if (!this.isServiceConfigurationListenerServiceDef(serviceDef)) {
            this.serviceConfigurationListener.onOrderedConfiguration(serviceDef, result);
        }
        return result;
    }

    private boolean isServiceConfigurationListenerServiceDef(ServiceDef serviceDef) {
        return serviceDef.getServiceId().equalsIgnoreCase(ServiceConfigurationListener.class.getSimpleName());
    }

    @Override
    public <K, V> Map<K, V> getMappedConfiguration(ServiceDef3 serviceDef, Class<K> keyType, Class<V> objectType) {
        this.lock.check();
        Map<K, V> result = this.newConfigurationMap(keyType);
        Map<K, V> keyToContribution = this.newConfigurationMap(keyType);
        Map<K, V> overrides = this.newConfigurationMap(keyType);
        for (Module m : this.moduleToServiceDefs.keySet()) {
            this.addToMappedConfiguration(result, overrides, keyToContribution, keyType, objectType, serviceDef, m);
        }
        for (MappedConfigurationOverride override : overrides.values()) {
            override.apply();
        }
        if (!this.isServiceConfigurationListenerServiceDef(serviceDef)) {
            this.serviceConfigurationListener.onMappedConfiguration(serviceDef, result);
        }
        return result;
    }

    private <K, V> Map<K, V> newConfigurationMap(Class<K> keyType) {
        if (keyType.equals(String.class)) {
            Map result = CollectionFactory.newCaseInsensitiveMap();
            return result;
        }
        return CollectionFactory.newMap();
    }

    private <K, V> void addToMappedConfiguration(Map<K, V> map, Map<K, MappedConfigurationOverride<K, V>> overrides, Map<K, ContributionDef> keyToContribution, Class<K> keyClass, Class<V> valueType, ServiceDef3 serviceDef, final Module module) {
        String serviceId = serviceDef.getServiceId();
        Set<ContributionDef2> contributions = module.getContributorDefsForService(serviceDef);
        if (contributions.isEmpty()) {
            return;
        }
        Logger logger = this.getServiceLogger(serviceId);
        final ServiceResourcesImpl resources = new ServiceResourcesImpl(this, module, serviceDef, this.proxyFactory, logger);
        for (final ContributionDef contributionDef : contributions) {
            final ValidatingMappedConfigurationWrapper<K, V> validating = new ValidatingMappedConfigurationWrapper<K, V>(valueType, resources, this.typeCoercerProxy, map, overrides, serviceId, contributionDef, keyClass, keyToContribution);
            String description = "Invoking " + contributionDef;
            logger.debug(description);
            this.operationTracker.run(description, new Runnable(){

                @Override
                public void run() {
                    contributionDef.contribute((ModuleBuilderSource)module, resources, validating);
                }
            });
        }
    }

    private <T> void addToUnorderedConfiguration(Collection<T> collection, Class<T> valueType, ServiceDef3 serviceDef, final Module module) {
        String serviceId = serviceDef.getServiceId();
        Set<ContributionDef2> contributions = module.getContributorDefsForService(serviceDef);
        if (contributions.isEmpty()) {
            return;
        }
        Logger logger = this.getServiceLogger(serviceId);
        final ServiceResourcesImpl resources = new ServiceResourcesImpl(this, module, serviceDef, this.proxyFactory, logger);
        for (final ContributionDef contributionDef : contributions) {
            final ValidatingConfigurationWrapper<T> validating = new ValidatingConfigurationWrapper<T>(valueType, resources, this.typeCoercerProxy, collection, serviceId);
            String description = "Invoking " + contributionDef;
            logger.debug(description);
            this.operationTracker.run(description, new Runnable(){

                @Override
                public void run() {
                    contributionDef.contribute((ModuleBuilderSource)module, resources, validating);
                }
            });
        }
    }

    private <T> void addToOrderedConfiguration(Orderer<T> orderer, Map<String, OrderedConfigurationOverride<T>> overrides, Class<T> valueType, ServiceDef3 serviceDef, final Module module) {
        String serviceId = serviceDef.getServiceId();
        Set<ContributionDef2> contributions = module.getContributorDefsForService(serviceDef);
        if (contributions.isEmpty()) {
            return;
        }
        Logger logger = this.getServiceLogger(serviceId);
        final ServiceResourcesImpl resources = new ServiceResourcesImpl(this, module, serviceDef, this.proxyFactory, logger);
        for (final ContributionDef contributionDef : contributions) {
            final ValidatingOrderedConfigurationWrapper<T> validating = new ValidatingOrderedConfigurationWrapper<T>(valueType, resources, this.typeCoercerProxy, orderer, overrides, contributionDef);
            String description = "Invoking " + contributionDef;
            logger.debug(description);
            this.operationTracker.run(description, new Runnable(){

                @Override
                public void run() {
                    contributionDef.contribute((ModuleBuilderSource)module, resources, validating);
                }
            });
        }
    }

    @Override
    public <T> T getService(Class<T> serviceInterface) {
        this.lock.check();
        return this.getServiceByTypeAndMarkers(serviceInterface, new Class[0]);
    }

    @Override
    public <T> T getService(Class<T> serviceInterface, Class<? extends Annotation> ... markerTypes) {
        this.lock.check();
        return this.getServiceByTypeAndMarkers(serviceInterface, markerTypes);
    }

    private <T> T getServiceByTypeAlone(Class<T> serviceInterface) {
        List<String> serviceIds = this.findServiceIdsForInterface(serviceInterface);
        if (serviceIds == null) {
            serviceIds = Collections.emptyList();
        }
        switch (serviceIds.size()) {
            case 0: {
                throw new RuntimeException(IOCMessages.noServiceMatchesType(serviceInterface));
            }
            case 1: {
                String serviceId = serviceIds.get(0);
                return this.getService(serviceId, serviceInterface);
            }
        }
        Collections.sort(serviceIds);
        throw new RuntimeException(IOCMessages.manyServiceMatches(serviceInterface, serviceIds));
    }

    private <T> T getServiceByTypeAndMarkers(Class<T> serviceInterface, Class<? extends Annotation> ... markerTypes) {
        if (markerTypes.length == 0) {
            return this.getServiceByTypeAlone(serviceInterface);
        }
        AnnotationProvider provider = this.createAnnotationProvider(markerTypes);
        Set<ServiceDef2> matches = CollectionFactory.newSet();
        List<Class> markers = CollectionFactory.newList();
        this.findServiceDefsMatchingMarkerAndType(serviceInterface, provider, null, markers, matches);
        return this.extractServiceFromMatches(serviceInterface, markers, matches);
    }

    private AnnotationProvider createAnnotationProvider(Class<? extends Annotation> ... markerTypes) {
        final Map<Class<? extends Annotation>, Annotation> map = CollectionFactory.newMap();
        for (Class<? extends Annotation> markerType : markerTypes) {
            map.put(markerType, this.createAnnotationProxy(markerType));
        }
        return new AnnotationProvider(){

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return (T)((Annotation)annotationClass.cast(map.get(annotationClass)));
            }
        };
    }

    private <A extends Annotation> Annotation createAnnotationProxy(final Class<A> annotationType) {
        Annotation result = this.cachedAnnotationProxies.get(annotationType);
        if (result == null) {
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("annotationType")) {
                        return annotationType;
                    }
                    return method.invoke(proxy, args);
                }
            };
            result = (Annotation)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{annotationType}, handler);
            this.cachedAnnotationProxies.put(annotationType, result);
        }
        return result;
    }

    private List<String> findServiceIdsForInterface(Class serviceInterface) {
        List<String> result = CollectionFactory.newList();
        for (Module module : this.moduleToServiceDefs.keySet()) {
            result.addAll(module.findServiceIdsForInterface(serviceInterface));
        }
        for (Map.Entry entry : this.builtinServices.entrySet()) {
            if (!serviceInterface.isInstance(entry.getValue())) continue;
            result.add((String)entry.getKey());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public ServiceLifecycle2 getServiceLifecycle(String scope) {
        this.lock.check();
        ServiceLifecycle result = this.lifecycles.get(scope);
        if (result == null) {
            ServiceLifecycleSource source = this.getService("ServiceLifecycleSource", ServiceLifecycleSource.class);
            result = source.get(scope);
        }
        if (result == null) {
            throw new RuntimeException(IOCMessages.unknownScope(scope));
        }
        return InternalUtils.toServiceLifecycle2(result);
    }

    @Override
    public List<ServiceDecorator> findDecoratorsForService(ServiceDef3 serviceDef) {
        this.lock.check();
        assert (serviceDef != null);
        Logger logger = this.getServiceLogger(serviceDef.getServiceId());
        Orderer<ServiceDecorator> orderer = new Orderer<ServiceDecorator>(logger, true);
        for (Module module : this.moduleToServiceDefs.keySet()) {
            Set<DecoratorDef> decoratorDefs = module.findMatchingDecoratorDefs(serviceDef);
            if (decoratorDefs.isEmpty()) continue;
            ServiceResourcesImpl resources = new ServiceResourcesImpl(this, module, serviceDef, this.proxyFactory, logger);
            for (DecoratorDef decoratorDef : decoratorDefs) {
                ServiceDecorator decorator = decoratorDef.createDecorator(module, resources);
                try {
                    orderer.add(decoratorDef.getDecoratorId(), decorator, decoratorDef.getConstraints());
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(String.format("Service %s has two different decorators methods named decorate%s in different module classes. You can solve this by renaming one of them and annotating it with @Match(\"%2$s\").", serviceDef.getServiceId(), decoratorDef.getDecoratorId()));
                }
            }
        }
        return orderer.getOrdered();
    }

    @Override
    public List<ServiceAdvisor> findAdvisorsForService(ServiceDef3 serviceDef) {
        this.lock.check();
        assert (serviceDef != null);
        Logger logger = this.getServiceLogger(serviceDef.getServiceId());
        Orderer<ServiceAdvisor> orderer = new Orderer<ServiceAdvisor>(logger);
        for (Module module : this.moduleToServiceDefs.keySet()) {
            Set<AdvisorDef> advisorDefs = module.findMatchingServiceAdvisors(serviceDef);
            if (advisorDefs.isEmpty()) continue;
            ServiceResourcesImpl resources = new ServiceResourcesImpl(this, module, serviceDef, this.proxyFactory, logger);
            for (AdvisorDef advisorDef : advisorDefs) {
                ServiceAdvisor advisor = advisorDef.createAdvisor(module, resources);
                orderer.add(advisorDef.getAdvisorId(), advisor, advisorDef.getConstraints());
            }
        }
        return orderer.getOrdered();
    }

    @Override
    public <T> T getObject(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator, Module localModule) {
        this.lock.check();
        AnnotationProvider effectiveProvider = annotationProvider != null ? annotationProvider : new NullAnnotationProvider();
        T result = this.findServiceByMarkerAndType(objectType, annotationProvider, localModule);
        if (result != null) {
            return result;
        }
        MasterObjectProvider masterProvider = this.getService("MasterObjectProvider", MasterObjectProvider.class);
        return masterProvider.provide(objectType, effectiveProvider, locator, true);
    }

    private Collection<ServiceDef2> filterByType(Class<?> objectType, Collection<ServiceDef2> serviceDefs) {
        Set<ServiceDef2> result = CollectionFactory.newSet();
        for (ServiceDef2 sd : serviceDefs) {
            if (!objectType.isAssignableFrom(sd.getServiceInterface())) continue;
            result.add(sd);
        }
        return result;
    }

    private <T> T findServiceByMarkerAndType(Class<T> objectType, AnnotationProvider provider, Module localModule) {
        if (provider == null) {
            return null;
        }
        Set<ServiceDef2> matches = CollectionFactory.newSet();
        List<Class> markers = CollectionFactory.newList();
        this.findServiceDefsMatchingMarkerAndType(objectType, provider, localModule, markers, matches);
        if (markers.isEmpty()) {
            return null;
        }
        return this.extractServiceFromMatches(objectType, markers, matches);
    }

    private <T> T extractServiceFromMatches(Class<T> objectType, List<Class> markers, Set<ServiceDef2> matches) {
        switch (matches.size()) {
            case 1: {
                ServiceDef def = matches.iterator().next();
                return this.getService(def.getServiceId(), objectType);
            }
            case 0: {
                throw new RuntimeException(IOCMessages.noServicesMatchMarker(objectType, markers));
            }
        }
        throw new RuntimeException(IOCMessages.manyServicesMatchMarker(objectType, markers, matches));
    }

    private <T> void findServiceDefsMatchingMarkerAndType(Class<T> objectType, AnnotationProvider provider, Module localModule, List<Class> markers, Set<ServiceDef2> matches) {
        assert (provider != null);
        boolean localOnly = localModule != null && provider.getAnnotation(Local.class) != null;
        matches.addAll(this.filterByType(objectType, localOnly ? this.moduleToServiceDefs.get(localModule) : this.allServiceDefs));
        if (localOnly) {
            markers.add(Local.class);
        }
        for (Class marker : this.markerToServiceDef.keySet()) {
            if (provider.getAnnotation(marker) == null) continue;
            markers.add(marker);
            matches.retainAll((Collection)this.markerToServiceDef.get(marker));
            if (!matches.isEmpty()) continue;
            return;
        }
    }

    @Override
    public <T> T getObject(Class<T> objectType, AnnotationProvider annotationProvider) {
        return this.getObject(objectType, annotationProvider, this, null);
    }

    @Override
    public void addRegistryShutdownListener(RegistryShutdownListener listener) {
        this.lock.check();
        this.registryShutdownHub.addRegistryShutdownListener(listener);
    }

    @Override
    public void addRegistryShutdownListener(Runnable listener) {
        this.lock.check();
        this.registryShutdownHub.addRegistryShutdownListener(listener);
    }

    @Override
    public void addRegistryWillShutdownListener(Runnable listener) {
        this.lock.check();
        this.registryShutdownHub.addRegistryWillShutdownListener(listener);
    }

    @Override
    public String expandSymbols(String input) {
        this.lock.check();
        if (!InternalUtils.containsSymbols(input)) {
            return input;
        }
        return this.getSymbolSource().expandSymbols(input);
    }

    private SymbolSource getSymbolSource() {
        if (this.symbolSource == null) {
            this.symbolSource = this.getService(SYMBOL_SOURCE_SERVICE_ID, SymbolSource.class);
        }
        return this.symbolSource;
    }

    @Override
    public <T> T autobuild(String description, final Class<T> clazz) {
        return this.invoke(description, new Invokable<T>(){

            @Override
            public T invoke() {
                return RegistryImpl.this.autobuild(clazz);
            }
        });
    }

    @Override
    public <T> T autobuild(Class<T> clazz) {
        assert (clazz != null);
        Constructor constructor = InternalUtils.findAutobuildConstructor(clazz);
        if (constructor == null) {
            throw new RuntimeException(IOCMessages.noAutobuildConstructor(clazz));
        }
        Map<Class, Object> resourcesMap = CollectionFactory.newMap();
        resourcesMap.put(OperationTracker.class, this);
        MapInjectionResources resources = new MapInjectionResources(resourcesMap);
        ObjectCreator plan = InternalUtils.createConstructorConstructionPlan(this, this, resources, null, "Invoking " + this.proxyFactory.getConstructorLocation(constructor).toString(), constructor);
        return plan.createObject();
    }

    @Override
    public <T> T proxy(Class<T> interfaceClass, Class<? extends T> implementationClass) {
        return this.proxy(interfaceClass, implementationClass, this);
    }

    @Override
    public <T> T proxy(Class<T> interfaceClass, Class<? extends T> implementationClass, ObjectLocator locator) {
        assert (interfaceClass != null);
        assert (implementationClass != null);
        if (InternalUtils.SERVICE_CLASS_RELOADING_ENABLED && InternalUtils.isLocalFile(implementationClass)) {
            return this.createReloadingProxy(interfaceClass, implementationClass, locator);
        }
        return this.createNonReloadingProxy(interfaceClass, implementationClass, locator);
    }

    private <T> T createNonReloadingProxy(Class<T> interfaceClass, final Class<? extends T> implementationClass, final ObjectLocator locator) {
        final ObjectCreator autobuildCreator = new ObjectCreator<T>(){

            @Override
            public T createObject() {
                return locator.autobuild(implementationClass);
            }
        };
        ObjectCreator justInTime = new ObjectCreator<T>(){
            private T delegate;

            @Override
            public synchronized T createObject() {
                if (this.delegate == null) {
                    this.delegate = autobuildCreator.createObject();
                }
                return this.delegate;
            }
        };
        return this.proxyFactory.createProxy(interfaceClass, justInTime, String.format("<Autobuild proxy %s(%s)>", implementationClass.getName(), interfaceClass.getName()));
    }

    private <T> T createReloadingProxy(Class<T> interfaceClass, Class<? extends T> implementationClass, ObjectLocator locator) {
        ReloadableObjectCreator creator = new ReloadableObjectCreator(this.proxyFactory, implementationClass.getClassLoader(), implementationClass.getName(), this.loggerSource.getLogger(implementationClass), this, locator);
        this.getService(UpdateListenerHub.class).addUpdateListener(creator);
        return this.proxyFactory.createProxy(interfaceClass, implementationClass, creator, String.format("<Autoreload proxy %s(%s)>", implementationClass.getName(), interfaceClass.getName()));
    }

    @Override
    public Object provideServiceProxy(String serviceId) {
        return this.getService(serviceId, Object.class);
    }

    @Override
    public void run(String description, Runnable operation) {
        this.operationTracker.run(description, operation);
    }

    @Override
    public <T> T invoke(String description, Invokable<T> operation) {
        return this.operationTracker.invoke(description, operation);
    }

    @Override
    public <T> T perform(String description, IOOperation<T> operation) throws IOException {
        return this.operationTracker.perform(description, operation);
    }

    @Override
    public Set<Class> getMarkerAnnotations() {
        return this.markerToServiceDef.keySet();
    }

    static {
        BUILTIN.add(Builtin.class);
    }

    private static final class DelegatingServiceConfigurationListener
    implements ServiceConfigurationListener {
        private final Logger logger;
        private List<ServiceConfigurationListener> delegates;
        private Map<ServiceDef, Map> mapped = CollectionFactory.newMap();
        private Map<ServiceDef, Collection> unordered = CollectionFactory.newMap();
        private Map<ServiceDef, List> ordered = CollectionFactory.newMap();

        public DelegatingServiceConfigurationListener(Logger logger) {
            this.logger = logger;
        }

        public void setDelegates(List<ServiceConfigurationListener> delegates) {
            this.delegates = delegates;
            for (ServiceDef serviceDef : this.mapped.keySet()) {
                for (ServiceConfigurationListener delegate : delegates) {
                    delegate.onMappedConfiguration(serviceDef, Collections.unmodifiableMap(this.mapped.get(serviceDef)));
                }
            }
            for (ServiceDef serviceDef : this.unordered.keySet()) {
                for (ServiceConfigurationListener delegate : delegates) {
                    delegate.onUnorderedConfiguration(serviceDef, Collections.unmodifiableCollection(this.unordered.get(serviceDef)));
                }
            }
            for (ServiceDef serviceDef : this.ordered.keySet()) {
                for (ServiceConfigurationListener delegate : delegates) {
                    delegate.onOrderedConfiguration(serviceDef, Collections.unmodifiableList(this.ordered.get(serviceDef)));
                }
            }
            this.mapped.clear();
            this.mapped = null;
            this.unordered.clear();
            this.unordered = null;
            this.ordered.clear();
            this.ordered = null;
        }

        @Override
        public void onOrderedConfiguration(ServiceDef serviceDef, List configuration) {
            this.log("ordered", serviceDef, configuration);
            if (this.delegates == null) {
                this.ordered.put(serviceDef, configuration);
            } else {
                for (ServiceConfigurationListener delegate : this.delegates) {
                    delegate.onOrderedConfiguration(serviceDef, Collections.unmodifiableList(configuration));
                }
            }
        }

        @Override
        public void onUnorderedConfiguration(ServiceDef serviceDef, Collection configuration) {
            this.log("unordered", serviceDef, configuration);
            if (this.delegates == null) {
                this.unordered.put(serviceDef, configuration);
            } else {
                for (ServiceConfigurationListener delegate : this.delegates) {
                    delegate.onUnorderedConfiguration(serviceDef, Collections.unmodifiableCollection(configuration));
                }
            }
        }

        @Override
        public void onMappedConfiguration(ServiceDef serviceDef, Map configuration) {
            this.log("mapped", serviceDef, configuration);
            if (this.delegates == null) {
                this.mapped.put(serviceDef, configuration);
            } else {
                for (ServiceConfigurationListener delegate : this.delegates) {
                    delegate.onMappedConfiguration(serviceDef, Collections.unmodifiableMap(configuration));
                }
            }
        }

        private void log(String type, ServiceDef serviceDef, Object configuration) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Service %s %s configuration: %s", serviceDef.getServiceId(), type, configuration.toString()));
            }
        }
    }

    private static final class ModuleComparator
    implements Comparator<Module> {
        private ModuleComparator() {
        }

        @Override
        public int compare(Module m1, Module m2) {
            return m1.getLoggerName().compareTo(m2.getLoggerName());
        }
    }
}

