/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.apache.tapestry5.ioc.IdMatcher;
import org.apache.tapestry5.ioc.def.ServiceDef;
import org.apache.tapestry5.ioc.internal.IdMatcherImpl;
import org.apache.tapestry5.ioc.internal.OrIdMatcher;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;

public class AbstractServiceInstrumenter {
    protected final Method method;
    protected final IdMatcher idMatcher;
    protected final String[] constraints;
    protected final PlasticProxyFactory proxyFactory;
    private final Set<Class> markers;
    private final Class serviceInterface;

    public AbstractServiceInstrumenter(Method method, String[] patterns, String[] constraints, Class serviceInterface, Set<Class> markers, PlasticProxyFactory proxyFactory) {
        this.method = method;
        this.serviceInterface = serviceInterface;
        this.markers = markers;
        this.proxyFactory = proxyFactory;
        assert (patterns != null);
        List<IdMatcher> matchers = CollectionFactory.newList();
        for (String pattern : patterns) {
            IdMatcherImpl matcher = new IdMatcherImpl(pattern);
            matchers.add(matcher);
        }
        this.idMatcher = new OrIdMatcher(matchers);
        this.constraints = constraints != null ? constraints : new String[]{};
    }

    public String toString() {
        return InternalUtils.asString(this.method, this.proxyFactory);
    }

    public String[] getConstraints() {
        return this.constraints;
    }

    public boolean matches(ServiceDef serviceDef) {
        String serviceId = serviceDef.getServiceId();
        return this.idMatcher.matches(serviceId);
    }

    public Set<Class> getMarkers() {
        return this.markers;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }
}

