/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.util;

import java.util.Locale;
import java.util.Map;
import org.apache.tapestry5.ioc.MessageFormatter;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.MessageFormatterImpl;

public abstract class AbstractMessages
implements Messages {
    private final Map<String, MessageFormatter> cache = CollectionFactory.newConcurrentMap();
    private final Locale locale;

    protected AbstractMessages(Locale locale) {
        this.locale = locale;
    }

    protected abstract String valueForKey(String var1);

    public boolean contains(String key) {
        return this.valueForKey(key) != null;
    }

    public String get(String key) {
        if (this.contains(key)) {
            return this.valueForKey(key);
        }
        return String.format("[[missing key: %s]]", key);
    }

    public MessageFormatter getFormatter(String key) {
        MessageFormatter result = this.cache.get(key);
        if (result == null) {
            result = this.buildMessageFormatter(key);
            this.cache.put(key, result);
        }
        return result;
    }

    private MessageFormatter buildMessageFormatter(String key) {
        String format = this.get(key);
        return new MessageFormatterImpl(format, this.locale);
    }

    public String format(String key, Object ... args) {
        return this.getFormatter(key).format(args);
    }
}

