/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.util.Collections;
import java.util.List;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ServiceDecorator;
import org.apache.tapestry5.ioc.def.ServiceDef3;
import org.apache.tapestry5.ioc.internal.InternalRegistry;

public class InterceptorStackBuilder
implements ObjectCreator {
    private final ServiceDef3 serviceDef;
    private final ObjectCreator delegate;
    private final InternalRegistry registry;

    public InterceptorStackBuilder(ServiceDef3 serviceDef, ObjectCreator delegate, InternalRegistry registry) {
        this.serviceDef = serviceDef;
        this.delegate = delegate;
        this.registry = registry;
    }

    public Object createObject() {
        Object current = this.delegate.createObject();
        List<ServiceDecorator> decorators = this.registry.findDecoratorsForService(this.serviceDef);
        Collections.reverse(decorators);
        for (final ServiceDecorator decorator : decorators) {
            final Object delegate = current;
            Object interceptor = this.registry.invoke("Invoking " + decorator, new Invokable<Object>(){

                @Override
                public Object invoke() {
                    return decorator.createInterceptor(delegate);
                }
            });
            if (interceptor == null) continue;
            current = interceptor;
        }
        return current;
    }
}

