/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.tapestry5.ioc.util.CaseInsensitiveMap;
import org.apache.tapestry5.ioc.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionFactory {
    public static <K, V> Map<K, V> newMap() {
        return new HashMap();
    }

    public static <T> Set<T> newSet() {
        return new HashSet();
    }

    public static <T, V extends T> Set<T> newSet(Collection<V> values) {
        return new HashSet<V>(values);
    }

    public static <T, V extends T> Set<T> newSet(V ... values) {
        return new HashSet<V>(Arrays.asList(values));
    }

    public static <K, V> Map<K, V> newMap(Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> Map<K, V> newWeakHashMap() {
        return new WeakHashMap();
    }

    public static <T> List<T> newList() {
        return new ArrayList();
    }

    public static <T, V extends T> List<T> newList(V ... elements) {
        return new ArrayList<V>(Arrays.asList(elements));
    }

    public static <T> LinkedList<T> newLinkedList() {
        return new LinkedList();
    }

    public static <T, V extends T> List<T> newList(Collection<V> list) {
        return new ArrayList<V>(list);
    }

    public static <T> List<T> newThreadSafeList() {
        return new CopyOnWriteArrayList();
    }

    public static <T> Stack<T> newStack() {
        return new Stack();
    }

    public static <T> Stack<T> newStack(int initialSize) {
        return new Stack(initialSize);
    }

    public static <V> Map<String, V> newCaseInsensitiveMap() {
        return new CaseInsensitiveMap();
    }

    public static <V> Map<String, V> newCaseInsensitiveMap(Map<String, ? extends V> map) {
        return new CaseInsensitiveMap<V>(map);
    }
}

