/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.task;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.SynapseTaskException;
import org.apache.synapse.task.TaskDescriptionRepository;

public class TaskDescriptionRepositoryFactory {
    private static final Log log = LogFactory.getLog(TaskDescriptionRepositoryFactory.class);
    private static final Map<String, TaskDescriptionRepository> repositoryMap = new HashMap<String, TaskDescriptionRepository>();

    private TaskDescriptionRepositoryFactory() {
    }

    public static TaskDescriptionRepository getTaskDescriptionRepository(String id) {
        if (id == null || "".equals(id)) {
            throw new SynapseTaskException("Name cannot be found.", log);
        }
        TaskDescriptionRepository repository = repositoryMap.get(id);
        if (repository == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating a TaskDescriptionRepository with id : " + id));
            }
            repository = new TaskDescriptionRepository();
            repositoryMap.put(id, repository);
        }
        return repository;
    }
}

