/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.tiles;

import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.util.WildcardUtil;
import com.opensymphony.xwork2.util.finder.ResourceFinder;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.tiles.servlet.context.ServletTilesApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrutsWildcardServletTilesApplicationContext
extends ServletTilesApplicationContext {
    private static final Logger LOG = LoggerFactory.getLogger(StrutsWildcardServletTilesApplicationContext.class);
    private ResourceFinder finder;

    public StrutsWildcardServletTilesApplicationContext(ServletContext context) {
        super(context);
        HashSet<URL> urls = new HashSet<URL>();
        for (Object path : context.getResourcePaths("/")) {
            try {
                String realPath = context.getRealPath(String.valueOf(path));
                if (realPath == null) continue;
                URL url = new File(realPath).toURI().toURL();
                urls.add(url);
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException((Throwable)e);
            }
        }
        try {
            Enumeration<URL> resources = ((Object)((Object)this)).getClass().getClassLoader().getResources("/");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                urls.add(resource);
            }
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
        this.finder = new ResourceFinder(urls.toArray(new URL[urls.size()]));
    }

    public Set<URL> getResources(String path) throws IOException {
        HashSet<URL> resources = new HashSet<URL>();
        if (path.startsWith("/")) {
            LOG.trace("Using ServletContext to load resource #0", new String[]{path});
            URL resource = this.getResource(path);
            if (resource != null) {
                resources.add(resource);
            }
        }
        resources.addAll(this.findResources(path));
        return resources;
    }

    protected Set<URL> findResources(String path) throws IOException {
        HashSet<URL> resources = new HashSet<URL>();
        LOG.trace("Using ResourceFinder to find matches for #0", new String[]{path});
        Pattern pattern = WildcardUtil.compileWildcardPattern((String)path);
        Map matches = this.finder.getResourcesMap("");
        for (String resource : matches.keySet()) {
            if (!pattern.matcher(resource).matches()) continue;
            resources.add((URL)matches.get(resource));
        }
        LOG.trace("Found resources #0 for path #1", new Object[]{resources, path});
        return resources;
    }
}

