/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.rest.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.opensymphony.xwork2.inject.Inject;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.struts2.rest.handler.ContentTypeHandler;

public class JacksonLibHandler
implements ContentTypeHandler {
    private static final String DEFAULT_CONTENT_TYPE = "application/json";
    private String defaultEncoding = "ISO-8859-1";
    private ObjectMapper mapper = new ObjectMapper();

    @Override
    public void toObject(Reader in, Object target) throws IOException {
        this.mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        ObjectReader or = this.mapper.readerForUpdating(target);
        or.readValue(in);
    }

    @Override
    public String fromObject(Object obj, String resultCode, Writer stream) throws IOException {
        this.mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        this.mapper.writeValue(stream, obj);
        return null;
    }

    @Override
    public String getContentType() {
        return "application/json;charset=" + this.defaultEncoding;
    }

    @Override
    public String getExtension() {
        return "json";
    }

    @Inject(value="struts.i18n.encoding")
    public void setDefaultEncoding(String val) {
        this.defaultEncoding = val;
    }
}

