/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.portlet.extractor;

import java.util.Enumeration;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.tiles.request.attribute.AttributeExtractor;

public class SessionScopeExtractor
implements AttributeExtractor {
    private final PortletRequest request;
    private final int scope;

    public SessionScopeExtractor(PortletRequest request, int scope) {
        this.request = request;
        if (scope != 1 && scope != 2) {
            throw new IllegalArgumentException("The scope must be either APPLICATION_SCOPE or PORTLET_SCOPE");
        }
        this.scope = scope;
    }

    public void setValue(String name, Object value) {
        this.request.getPortletSession().setAttribute(name, value, this.scope);
    }

    public void removeValue(String name) {
        PortletSession session = this.request.getPortletSession(false);
        if (session != null) {
            session.removeAttribute(name, this.scope);
        }
    }

    public Enumeration<String> getKeys() {
        PortletSession session = this.request.getPortletSession(false);
        if (session != null) {
            return session.getAttributeNames(this.scope);
        }
        return null;
    }

    public Object getValue(String key) {
        PortletSession session = this.request.getPortletSession(false);
        if (session != null) {
            return session.getAttribute(key, this.scope);
        }
        return null;
    }
}

