/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.StrutsException;
import org.apache.struts2.components.Form;
import org.apache.struts2.components.ServletUrlRenderer;
import org.apache.struts2.components.UrlProvider;
import org.apache.struts2.components.UrlRenderer;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.portlet.context.PortletActionContext;
import org.apache.struts2.portlet.util.PortletUrlHelper;
import org.apache.struts2.portlet.util.PortletUrlHelperJSR286;

public class PortletUrlRenderer
implements UrlRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(PortletUrlRenderer.class);
    private UrlRenderer servletRenderer = new ServletUrlRenderer();
    private PortletUrlHelper portletUrlHelper = PortletActionContext.isJSR268Supported() ? new PortletUrlHelperJSR286() : new PortletUrlHelper();

    @Inject
    public void setActionMapper(ActionMapper actionMapper) {
        this.servletRenderer.setActionMapper(actionMapper);
    }

    public void renderUrl(Writer writer, UrlProvider urlComponent) {
        String var;
        String scheme = urlComponent.getHttpServletRequest().getScheme();
        if (urlComponent.getScheme() != null) {
            scheme = urlComponent.getScheme();
        }
        String result = this.onlyActionSpecified(urlComponent) ? this.portletUrlHelper.buildUrl(urlComponent.getAction(), urlComponent.getNamespace(), urlComponent.getMethod(), urlComponent.getParameters(), urlComponent.getPortletUrlType(), urlComponent.getPortletMode(), urlComponent.getWindowState()) : (this.onlyValueSpecified(urlComponent) ? this.portletUrlHelper.buildResourceUrl(urlComponent.getValue(), urlComponent.getParameters()) : this.createDefaultUrl(urlComponent));
        String anchor = urlComponent.getAnchor();
        if (anchor != null && anchor.length() > 0) {
            result = result + '#' + anchor;
        }
        if ((var = urlComponent.getVar()) != null) {
            urlComponent.putInContext(result);
            urlComponent.getHttpServletRequest().setAttribute(var, (Object)result);
        } else {
            try {
                writer.write(result);
            }
            catch (IOException e) {
                throw new StrutsException("IOError: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private String createDefaultUrl(UrlProvider urlComponent) {
        ActionInvocation ai = (ActionInvocation)urlComponent.getStack().getContext().get("com.opensymphony.xwork2.ActionContext.actionInvocation");
        String action = ai.getProxy().getActionName();
        String result = this.portletUrlHelper.buildUrl(action, urlComponent.getNamespace(), urlComponent.getMethod(), urlComponent.getParameters(), urlComponent.getPortletUrlType(), urlComponent.getPortletMode(), urlComponent.getWindowState());
        return result;
    }

    private boolean onlyValueSpecified(UrlProvider urlComponent) {
        return urlComponent.getValue() != null && urlComponent.getAction() == null;
    }

    private boolean onlyActionSpecified(UrlProvider urlComponent) {
        return urlComponent.getValue() == null && urlComponent.getAction() != null;
    }

    public void renderFormUrl(Form formComponent) {
        if (PortletActionContext.getPortletContext() == null) {
            this.servletRenderer.renderFormUrl(formComponent);
        } else {
            String namespace = formComponent.determineNamespace(formComponent.namespace, formComponent.getStack(), formComponent.request);
            String action = null;
            if (formComponent.action != null) {
                action = formComponent.findString(formComponent.action);
            } else {
                ActionInvocation ai = (ActionInvocation)formComponent.getStack().getContext().get("com.opensymphony.xwork2.ActionContext.actionInvocation");
                action = ai.getProxy().getActionName();
            }
            String type = "action";
            if (StringUtils.isNotEmpty((String)formComponent.method) && "GET".equalsIgnoreCase(formComponent.method.trim())) {
                type = "render";
            }
            if (action != null) {
                String result = this.portletUrlHelper.buildUrl(action, namespace, null, formComponent.getParameters(), type, formComponent.portletMode, formComponent.windowState);
                formComponent.addParameter("action", (Object)result);
                String id = formComponent.getId();
                if (id == null) {
                    int slash = action.lastIndexOf(47);
                    int dot = action.indexOf(46, slash);
                    id = dot != -1 ? action.substring(slash + 1, dot) : action.substring(slash + 1);
                    formComponent.addParameter("id", (Object)formComponent.escape(id));
                }
            }
        }
    }

    public void beforeRenderUrl(UrlProvider urlComponent) {
        if (PortletActionContext.getPortletContext() == null) {
            this.servletRenderer.beforeRenderUrl(urlComponent);
        }
    }
}

