/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.portlet.dispatcher;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.util.FileManager;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.xwork.StringUtils;
import org.apache.struts2.StrutsException;
import org.apache.struts2.StrutsStatics;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.portlet.PortletActionConstants;
import org.apache.struts2.portlet.PortletApplicationMap;
import org.apache.struts2.portlet.PortletRequestMap;
import org.apache.struts2.portlet.PortletSessionMap;
import org.apache.struts2.portlet.servlet.PortletServletContext;
import org.apache.struts2.portlet.servlet.PortletServletRequest;
import org.apache.struts2.portlet.servlet.PortletServletResponse;
import org.apache.struts2.util.AttributeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jsr168Dispatcher
extends GenericPortlet
implements StrutsStatics,
PortletActionConstants {
    private static final Logger LOG = LoggerFactory.getLogger(Jsr168Dispatcher.class);
    private ActionProxyFactory factory = null;
    private Map<PortletMode, String> modeMap = new HashMap<PortletMode, String>(3);
    private Map<PortletMode, ActionMapping> actionMap = new HashMap<PortletMode, ActionMapping>(3);
    private String portletNamespace = null;
    private Dispatcher dispatcherUtils;
    private ActionMapper actionMapper;
    private Container container;

    public void init(PortletConfig cfg) throws PortletException {
        super.init(cfg);
        LOG.debug("Initializing portlet " + this.getPortletName(), new String[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration e = cfg.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = cfg.getInitParameter(name);
            params.put(name, value);
        }
        this.dispatcherUtils = new Dispatcher((ServletContext)new PortletServletContext(cfg.getPortletContext()), params);
        this.dispatcherUtils.init();
        if (this.factory == null) {
            this.factory = (ActionProxyFactory)this.dispatcherUtils.getConfigurationManager().getConfiguration().getContainer().getInstance(ActionProxyFactory.class);
        }
        this.portletNamespace = cfg.getInitParameter("portletNamespace");
        LOG.debug("PortletNamespace: " + this.portletNamespace, new String[0]);
        this.parseModeConfig(this.actionMap, cfg, PortletMode.VIEW, "viewNamespace", "defaultViewAction");
        this.parseModeConfig(this.actionMap, cfg, PortletMode.EDIT, "editNamespace", "defaultEditAction");
        this.parseModeConfig(this.actionMap, cfg, PortletMode.HELP, "helpNamespace", "defaultHelpAction");
        this.parseModeConfig(this.actionMap, cfg, new PortletMode("config"), "configNamespace", "defaultConfigAction");
        this.parseModeConfig(this.actionMap, cfg, new PortletMode("about"), "aboutNamespace", "defaultAboutAction");
        this.parseModeConfig(this.actionMap, cfg, new PortletMode("print"), "printNamespace", "defaultPrintAction");
        this.parseModeConfig(this.actionMap, cfg, new PortletMode("preview"), "previewNamespace", "defaultPreviewAction");
        this.parseModeConfig(this.actionMap, cfg, new PortletMode("edit_defaults"), "editDefaultsNamespace", "defaultEditDefaultsAction");
        if (StringUtils.isEmpty((String)this.portletNamespace)) {
            this.portletNamespace = "";
        }
        LocalizedTextUtil.addDefaultResourceBundle((String)"org/apache/struts2/struts-messages");
        this.container = this.dispatcherUtils.getContainer();
        if ("true".equalsIgnoreCase((String)this.container.getInstance(String.class, "struts.configuration.xml.reload"))) {
            FileManager.setReloadingConfigs((boolean)true);
        }
        this.actionMapper = (ActionMapper)this.container.getInstance(ActionMapper.class);
    }

    void parseModeConfig(Map<PortletMode, ActionMapping> actionMap, PortletConfig portletConfig, PortletMode portletMode, String nameSpaceParam, String defaultActionParam) {
        String namespace = portletConfig.getInitParameter(nameSpaceParam);
        if (StringUtils.isEmpty((String)namespace)) {
            namespace = "";
        }
        this.modeMap.put(portletMode, namespace);
        String defaultAction = portletConfig.getInitParameter(defaultActionParam);
        String method = null;
        if (StringUtils.isEmpty((String)defaultAction)) {
            defaultAction = "default";
        }
        if (defaultAction.indexOf(33) >= 0) {
            method = defaultAction.substring(defaultAction.indexOf(33) + 1);
            defaultAction = defaultAction.substring(0, defaultAction.indexOf(33));
        }
        StringBuffer fullPath = new StringBuffer();
        if (StringUtils.isNotEmpty((String)this.portletNamespace)) {
            fullPath.append(this.portletNamespace);
        }
        if (StringUtils.isNotEmpty((String)namespace)) {
            fullPath.append(namespace).append("/");
        } else {
            fullPath.append("/");
        }
        fullPath.append(defaultAction);
        ActionMapping mapping = new ActionMapping();
        mapping.setName(this.getActionName(fullPath.toString()));
        mapping.setNamespace(this.getNamespace(fullPath.toString()));
        if (method != null) {
            mapping.setMethod(method);
        }
        actionMap.put(portletMode, mapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        LOG.debug("Entering processAction", new String[0]);
        this.resetActionContext();
        try {
            this.serviceAction((PortletRequest)request, (PortletResponse)response, this.getRequestMap((PortletRequest)request), this.getParameterMap((PortletRequest)request), this.getSessionMap((PortletRequest)request), this.getApplicationMap(), this.portletNamespace, EVENT_PHASE);
            LOG.debug("Leaving processAction", new String[0]);
        }
        finally {
            ActionContext.setContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        LOG.debug("Entering render", new String[0]);
        this.resetActionContext();
        response.setTitle(this.getTitle(request));
        if (!request.getWindowState().equals((Object)WindowState.MINIMIZED)) {
            try {
                this.serviceAction((PortletRequest)request, (PortletResponse)response, this.getRequestMap((PortletRequest)request), this.getParameterMap((PortletRequest)request), this.getSessionMap((PortletRequest)request), this.getApplicationMap(), this.portletNamespace, RENDER_PHASE);
                LOG.debug("Leaving render", new String[0]);
            }
            finally {
                this.resetActionContext();
            }
        }
    }

    private void resetActionContext() {
        ActionContext.setContext(null);
    }

    public HashMap<String, Object> createContextMap(Map<String, Object> requestMap, Map<String, String[]> parameterMap, Map<String, Object> sessionMap, Map<String, Object> applicationMap, PortletRequest request, PortletResponse response, HttpServletRequest servletRequest, HttpServletResponse servletResponse, ServletContext servletContext, PortletConfig portletConfig, Integer phase) throws IOException {
        this.container.inject((Object)servletRequest);
        HashMap<String, Object> extraContext = new HashMap<String, Object>();
        extraContext.put("com.opensymphony.xwork2.dispatcher.HttpServletRequest", servletRequest);
        extraContext.put("com.opensymphony.xwork2.dispatcher.HttpServletResponse", servletResponse);
        extraContext.put("com.opensymphony.xwork2.dispatcher.ServletContext", servletContext);
        extraContext.put("com.opensymphony.xwork2.ActionContext.parameters", parameterMap);
        extraContext.put("com.opensymphony.xwork2.ActionContext.session", sessionMap);
        extraContext.put("com.opensymphony.xwork2.ActionContext.application", applicationMap);
        String defaultLocale = (String)this.dispatcherUtils.getContainer().getInstance(String.class, "struts.locale");
        Locale locale = null;
        locale = defaultLocale != null ? LocalizedTextUtil.localeFromString((String)defaultLocale, (Locale)request.getLocale()) : request.getLocale();
        extraContext.put("com.opensymphony.xwork2.ActionContext.locale", locale);
        extraContext.put("struts.portlet.context", this.getPortletContext());
        extraContext.put("struts.portlet.request", request);
        extraContext.put("struts.portlet.response", response);
        extraContext.put("struts.portlet.config", portletConfig);
        extraContext.put("struts.portlet.portletNamespace", this.portletNamespace);
        extraContext.put("struts.portlet.defaultActionForMode", this.actionMap.get(request.getPortletMode()));
        extraContext.put("request", requestMap);
        extraContext.put("session", sessionMap);
        extraContext.put("application", applicationMap);
        extraContext.put("parameters", parameterMap);
        extraContext.put("struts.portlet.modeNamespaceMap", this.modeMap);
        extraContext.put("struts.portlet.phase", phase);
        AttributeMap attrMap = new AttributeMap(extraContext);
        extraContext.put("attr", attrMap);
        return extraContext;
    }

    public void serviceAction(PortletRequest request, PortletResponse response, Map<String, Object> requestMap, Map<String, String[]> parameterMap, Map<String, Object> sessionMap, Map<String, Object> applicationMap, String portletNamespace, Integer phase) throws PortletException {
        LOG.debug("serviceAction", new String[0]);
        Dispatcher.setInstance((Dispatcher)this.dispatcherUtils);
        String actionName = null;
        String namespace = null;
        try {
            PortletServletContext servletContext = new PortletServletContext(this.getPortletContext());
            PortletServletRequest servletRequest = new PortletServletRequest(request, this.getPortletContext());
            PortletServletResponse servletResponse = new PortletServletResponse(response);
            if (EVENT_PHASE.equals(phase) && (servletRequest = this.dispatcherUtils.wrapRequest((HttpServletRequest)servletRequest, (ServletContext)servletContext)) instanceof MultiPartRequestWrapper) {
                parameterMap.putAll(servletRequest.getParameterMap());
            }
            this.container.inject((Object)servletRequest);
            ActionMapping mapping = this.getActionMapping(request, servletRequest);
            actionName = mapping.getName();
            namespace = mapping.getNamespace();
            HashMap<String, Object> extraContext = this.createContextMap(requestMap, parameterMap, sessionMap, applicationMap, request, response, servletRequest, servletResponse, servletContext, this.getPortletConfig(), phase);
            extraContext.put("struts.actionMapping", mapping);
            LOG.debug("Creating action proxy for name = " + actionName + ", namespace = " + namespace, new String[0]);
            ActionProxy proxy = this.factory.createActionProxy(namespace, actionName, mapping.getMethod(), extraContext);
            request.setAttribute("struts.valueStack", (Object)proxy.getInvocation().getStack());
            proxy.execute();
        }
        catch (ConfigurationException e) {
            LOG.error("Could not find action", (Throwable)e, new String[0]);
            throw new PortletException("Could not find action " + actionName, (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Could not execute action", (Throwable)e, new String[0]);
            throw new PortletException("Error executing action " + actionName, (Throwable)e);
        }
        finally {
            Dispatcher.setInstance(null);
        }
    }

    protected Map getApplicationMap() {
        return new PortletApplicationMap(this.getPortletContext());
    }

    protected ActionMapping getActionMapping(PortletRequest portletRequest, HttpServletRequest servletRequest) {
        ActionMapping mapping = null;
        String actionPath = null;
        mapping = this.resetAction(portletRequest) ? this.actionMap.get(portletRequest.getPortletMode()) : (StringUtils.isEmpty((String)(actionPath = servletRequest.getParameter("struts.portlet.action"))) ? this.actionMap.get(portletRequest.getPortletMode()) : this.actionMapper.getMapping(servletRequest, this.dispatcherUtils.getConfigurationManager()));
        if (mapping == null) {
            throw new StrutsException("Unable to locate action mapping for request, probably due to an invalid action path: " + actionPath);
        }
        return mapping;
    }

    String getNamespace(String actionPath) {
        int idx = actionPath.lastIndexOf(47);
        String namespace = "";
        if (idx >= 0) {
            namespace = actionPath.substring(0, idx);
        }
        return namespace;
    }

    String getActionName(String actionPath) {
        int idx = actionPath.lastIndexOf(47);
        String action = actionPath;
        if (idx >= 0) {
            action = actionPath.substring(idx + 1);
        }
        return action;
    }

    protected Map<String, String[]> getParameterMap(PortletRequest request) throws IOException {
        return new HashMap<String, String[]>(request.getParameterMap());
    }

    protected Map getRequestMap(PortletRequest request) {
        return new PortletRequestMap(request);
    }

    protected Map getSessionMap(PortletRequest request) {
        return new PortletSessionMap(request);
    }

    protected void setActionProxyFactory(ActionProxyFactory factory) {
        this.factory = factory;
    }

    private boolean resetAction(PortletRequest request) {
        boolean reset = false;
        Map paramMap = request.getParameterMap();
        String[] modeParam = (String[])paramMap.get("struts.portlet.mode");
        if (modeParam != null && modeParam.length == 1) {
            String originatingMode = modeParam[0];
            String currentMode = request.getPortletMode().toString();
            if (!currentMode.equals(originatingMode)) {
                reset = true;
            }
        }
        if (reset) {
            request.setAttribute("struts.portlet.actionReset", (Object)Boolean.TRUE);
        } else {
            request.setAttribute("struts.portlet.actionReset", (Object)Boolean.FALSE);
        }
        return reset;
    }

    public void destroy() {
        if (this.dispatcherUtils == null) {
            LOG.warn("something is seriously wrong, DispatcherUtil is not initialized (null) ", new String[0]);
        } else {
            this.dispatcherUtils.cleanup();
        }
    }

    public void setActionMapper(ActionMapper actionMapper) {
        this.actionMapper = actionMapper;
    }
}

