/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi.host;

import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.util.finder.ResourceFinder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.shell.ShellService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.StrutsException;
import org.apache.struts2.osgi.host.OsgiHost;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public abstract class BaseOsgiHost
implements OsgiHost {
    private static final Logger LOG = LogManager.getLogger(BaseOsgiHost.class);
    protected static final Pattern versionPattern = Pattern.compile("([\\d])+[\\.-]");
    protected ServletContext servletContext;

    @Override
    public abstract void init(ServletContext var1);

    @Override
    public abstract void destroy() throws Exception;

    @Override
    public abstract Map<String, Bundle> getBundles();

    @Override
    public abstract Map<String, Bundle> getActiveBundles();

    @Override
    public abstract BundleContext getBundleContext();

    protected abstract void addSpringOSGiSupport();

    protected String getServletContextParam(String paramName, String defaultValue) {
        return StringUtils.defaultString((String)this.servletContext.getInitParameter(paramName), (String)defaultValue);
    }

    protected void addAutoStartBundles(Properties configProps) {
        ArrayList<String> bundleJarsLevel1 = new ArrayList<String>();
        bundleJarsLevel1.add(this.getJarUrl(ShellService.class));
        bundleJarsLevel1.add(this.getJarUrl(ServiceTracker.class));
        configProps.put("felix.auto.start.1", StringUtils.join(bundleJarsLevel1, (String)" "));
        Map<String, String> runLevels = this.getRunLevelDirs("bundles");
        if (runLevels.isEmpty()) {
            List<String> bundles = this.getBundlesInDir("bundles");
            if (!bundles.isEmpty()) {
                configProps.put("felix.auto.start.2", StringUtils.join(bundles, (String)" "));
            }
        } else {
            for (String runLevel : runLevels.keySet()) {
                if ("1".endsWith(runLevel)) {
                    throw new StrutsException("Run level dirs must be greater than 1. Run level 1 is reserved for the Felix bundles");
                }
                List<String> bundles = this.getBundlesInDir(runLevels.get(runLevel));
                configProps.put("felix.auto.start." + runLevel, StringUtils.join(bundles, (String)" "));
            }
        }
    }

    protected Map<String, String> getRunLevelDirs(String dir) {
        HashMap<String, String> dirs = new HashMap<String, String>();
        try {
            ResourceFinder finder = new ResourceFinder(new URL[0]);
            URL url = finder.find("bundles");
            if (url != null) {
                if ("file".equals(url.getProtocol())) {
                    File bundlesDir = new File(url.toURI());
                    String[] runLevelDirs = bundlesDir.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File file, String name) {
                            try {
                                return file.isDirectory() && Integer.valueOf(name) > 0;
                            }
                            catch (NumberFormatException ex) {
                                return false;
                            }
                        }
                    });
                    if (runLevelDirs != null && runLevelDirs.length > 0) {
                        for (String runLevel : runLevelDirs) {
                            dirs.put(runLevel, StringUtils.removeEnd((String)dir, (String)"/") + "/" + runLevel);
                        }
                    } else {
                        LOG.debug("No run level directories found under the [{}] directory", (Object)dir);
                    }
                } else {
                    LOG.warn("Unable to read [{}] directory", (Object)dir);
                }
            } else {
                LOG.warn("The [{}] directory was not found", (Object)dir);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable load bundles from the [{}] directory", (Object)dir, (Object)e);
        }
        return dirs;
    }

    protected List<String> getBundlesInDir(String dir) {
        ArrayList<String> bundleJars = new ArrayList<String>();
        try {
            ResourceFinder finder = new ResourceFinder(new URL[0]);
            URL url = finder.find(dir);
            if (url != null) {
                if ("file".equals(url.getProtocol())) {
                    File bundlesDir = new File(url.toURI());
                    File[] bundles = bundlesDir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File file, String name) {
                            return StringUtils.endsWith((CharSequence)name, (CharSequence)".jar");
                        }
                    });
                    if (bundles != null && bundles.length > 0) {
                        for (File bundle : bundles) {
                            String externalForm = bundle.toURI().toURL().toExternalForm();
                            LOG.debug("Adding bundle [{}]", (Object)externalForm);
                            bundleJars.add(externalForm);
                        }
                    } else {
                        LOG.debug("No bundles found under the [{}] directory", (Object)dir);
                    }
                } else {
                    LOG.warn("Unable to read [{}] directory", (Object)dir);
                }
            } else {
                LOG.warn("The [{}] directory was not found", (Object)dir);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable load bundles from the [{}] directory", (Object)dir, (Object)e);
        }
        return bundleJars;
    }

    protected String getJarUrl(Class clazz) {
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL loc = codeSource.getLocation();
        return loc.toString();
    }

    protected void replaceSystemPackages(Properties properties) {
        String systemPackages = (String)properties.get("org.osgi.framework.system.packages");
        String jreVersion = "jre-" + System.getProperty("java.version").substring(0, 3);
        systemPackages = systemPackages.replace("${jre-${java.specification.version}}", (String)properties.get(jreVersion));
        properties.put("org.osgi.framework.system.packages", systemPackages);
    }

    protected void addExportedPackages(Properties strutsConfigProps, Properties configProps) {
        String[] rootPackages = StringUtils.split((String)((String)strutsConfigProps.get("scanning.package.includes")), (String)",");
        ResourceFinder finder = new ResourceFinder("");
        ArrayList<String> exportedPackages = new ArrayList<String>();
        for (String rootPackage : rootPackages) {
            try {
                String version = null;
                if (rootPackage.indexOf(";") > 0) {
                    String[] splitted = rootPackage.split(";");
                    rootPackage = splitted[0];
                    version = splitted[1];
                }
                Map subpackagesMap = finder.findPackagesMap(StringUtils.replace((String)rootPackage.trim(), (String)".", (String)"/"));
                for (Map.Entry entry : subpackagesMap.entrySet()) {
                    URL url = (URL)entry.getKey();
                    Set packages = (Set)entry.getValue();
                    if (StringUtils.isBlank((CharSequence)version)) {
                        version = this.getVersion(url);
                    }
                    if (packages == null) continue;
                    for (String subpackage : packages) {
                        exportedPackages.add(subpackage + "; version=" + version);
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Unable to find subpackages of [{}]", (Object)rootPackage, (Object)e);
            }
        }
        if (!exportedPackages.isEmpty()) {
            String systemPackages = (String)configProps.get("org.osgi.framework.system.packages");
            systemPackages = StringUtils.removeEnd((String)systemPackages, (String)",") + "," + StringUtils.join(exportedPackages, (String)",");
            configProps.put("org.osgi.framework.system.packages", systemPackages);
        }
    }

    protected String getVersion(URL url) {
        block5: {
            if ("jar".equals(url.getProtocol())) {
                try {
                    FileManager fileManager = ((FileManagerFactory)ServletActionContext.getContext().getInstance(FileManagerFactory.class)).getFileManager();
                    JarFile jarFile = new JarFile(new File(fileManager.normalizeToFileProtocol(url).toURI()));
                    Manifest manifest = jarFile.getManifest();
                    if (manifest != null) {
                        String version = manifest.getMainAttributes().getValue("Bundle-Version");
                        if (StringUtils.isNotBlank((CharSequence)version)) {
                            return this.getVersionFromString(version);
                        }
                        break block5;
                    }
                    return this.getVersionFromString(jarFile.getName());
                }
                catch (Exception e) {
                    LOG.error("Unable to extract version from [{}], defaulting to '1.0.0'", (Object)url.toExternalForm());
                }
            }
        }
        return "1.0.0";
    }

    protected String getVersionFromString(String str) {
        Matcher matcher = versionPattern.matcher(str);
        ArrayList<String> parts = new ArrayList<String>();
        while (matcher.find()) {
            parts.add(matcher.group(1));
        }
        if (parts.size() == 0) {
            return "1.0.0";
        }
        while (parts.size() < 3) {
            parts.add("0");
        }
        return StringUtils.join(parts, (String)".");
    }

    protected Properties getProperties(String fileName) {
        ResourceFinder finder = new ResourceFinder("");
        try {
            return finder.findProperties(fileName);
        }
        catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Unable to read property file [#]", (Object)fileName);
            }
            return new Properties();
        }
    }
}

