/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.osgi.interceptor.BundleContextAware;
import org.apache.struts2.osgi.interceptor.ServiceAware;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OsgiInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LogManager.getLogger(OsgiInterceptor.class);
    private BundleContext bundleContext;

    public String intercept(ActionInvocation invocation) throws Exception {
        if (this.bundleContext != null) {
            Type[] types;
            Object action = invocation.getAction();
            if (action instanceof BundleContextAware) {
                ((BundleContextAware)action).setBundleContext(this.bundleContext);
            }
            if (action instanceof ServiceAware && (types = action.getClass().getGenericInterfaces()) != null) {
                for (Type type : types) {
                    Class serviceClass;
                    ServiceReference[] refs;
                    Class clazz;
                    ParameterizedType parameterizedType;
                    if (!(type instanceof ParameterizedType) || !((parameterizedType = (ParameterizedType)type).getRawType() instanceof Class) || !ServiceAware.class.equals((Object)(clazz = (Class)parameterizedType.getRawType())) || (refs = this.bundleContext.getAllServiceReferences((serviceClass = (Class)parameterizedType.getActualTypeArguments()[0]).getName(), null)) == null) continue;
                    ArrayList<Object> services = new ArrayList<Object>(refs.length);
                    for (ServiceReference ref : refs) {
                        Object service = this.bundleContext.getService(ref);
                        if (service == null) continue;
                        services.add(service);
                    }
                    if (services.isEmpty()) continue;
                    ((ServiceAware)action).setServices(services);
                }
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("The OSGi interceptor was not able to find the BundleContext in the ServletContext");
        }
        return invocation.invoke();
    }

    @Inject
    public void setServletContext(ServletContext servletContext) {
        this.bundleContext = (BundleContext)servletContext.getAttribute("__struts_osgi_bundle_context");
    }
}

