/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.StrutsException;
import org.apache.struts2.osgi.OsgiHostFactory;
import org.apache.struts2.osgi.host.OsgiHost;

public class StrutsOsgiListener
implements ServletContextListener {
    public static final String OSGI_HOST = "__struts_osgi_host";
    public static final String PLATFORM_KEY = "struts.osgi.host";
    private static final Logger LOG = LogManager.getLogger(StrutsOsgiListener.class);
    private OsgiHost osgiHost;

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        String platform = servletContext.getInitParameter(PLATFORM_KEY);
        LOG.debug("Defined OSGi platform as [{}] via context-param [{}]", new Object[]{platform, PLATFORM_KEY});
        this.osgiHost = OsgiHostFactory.createOsgiHost(platform);
        servletContext.setAttribute(OSGI_HOST, (Object)this.osgiHost);
        try {
            this.osgiHost.init(servletContext);
        }
        catch (Exception e) {
            throw new StrutsException("Cannot init OSGi platform!", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            this.osgiHost.destroy();
        }
        catch (Exception e) {
            throw new StrutsException("Cannot stop OSGi platform!", (Throwable)e);
        }
    }
}

