/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.osgi.framework.Bundle;

public class OsgiUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiUtil.class);

    public static URL translateBundleURLToJarURL(URL bundleUrl, Bundle bundle) throws MalformedURLException {
        if (bundleUrl != null && "bundle".equalsIgnoreCase(bundleUrl.getProtocol())) {
            StringBuilder sb = new StringBuilder("jar:");
            sb.append(bundle.getLocation());
            sb.append("!");
            sb.append(bundleUrl.getFile());
            return new URL(sb.toString());
        }
        return bundleUrl;
    }

    public static Object getBean(Object beanFactory, String beanId) {
        try {
            Method getBeanMethod = beanFactory.getClass().getMethod("getBean", String.class);
            return getBeanMethod.invoke(beanFactory, beanId);
        }
        catch (Exception ex) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Unable to call getBean() on object of type [#0], with bean id [#1]", (Throwable)ex, new String[]{beanFactory.getClass().getName(), beanId});
            }
            return null;
        }
    }

    public static boolean containsBean(Object beanFactory, String beanId) {
        try {
            Method getBeanMethod = beanFactory.getClass().getMethod("containsBean", String.class);
            return (Boolean)getBeanMethod.invoke(beanFactory, beanId);
        }
        catch (Exception ex) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Unable to call containsBean() on object of type [#0], with bean id [#1]", (Throwable)ex, new String[]{beanFactory.getClass().getName(), beanId});
            }
            return false;
        }
    }
}

