/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi.host;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.felix.shell.ShellService;
import org.apache.struts2.osgi.host.BaseOsgiHost;
import org.apache.struts2.osgi.host.OsgiHost;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassfishOSGiHost
extends BaseOsgiHost
implements OsgiHost {
    private static final Logger LOG = LoggerFactory.getLogger(GlassfishOSGiHost.class);
    private static final String BUNDLES_DIR = "/WEB-INF/classes/bundles/2/";
    private BundleContext bctx = null;

    @Override
    public void init(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.installManagedBundles();
        this.addSpringOSGiSupport();
        servletContext.setAttribute("__struts_osgi_bundle_context", (Object)this.bctx);
    }

    private void installManagedBundles() {
        try {
            BundleReference ref = (BundleReference)this.servletContext.getClass().getClassLoader();
            this.bctx = ref.getBundle().getBundleContext();
            this.installBundles();
        }
        catch (Exception ex) {
            LOG.error("Installing Managed Bundles met a problem", (Throwable)ex, new String[0]);
        }
    }

    private void installBundles() throws Exception {
        ArrayList<Bundle> installed = new ArrayList<Bundle>();
        for (URL url : this.findBundles()) {
            LOG.debug("Installing bundle [" + url + "]", new String[0]);
            Bundle bundle = this.bctx.installBundle(url.toExternalForm());
            installed.add(bundle);
        }
        for (Bundle bundle : installed) {
            try {
                bundle.start();
            }
            catch (BundleException e) {
                e.printStackTrace();
                LOG.error("Failed to start " + bundle, (Throwable)e, new String[0]);
            }
        }
    }

    private List<URL> findBundles() throws Exception {
        ArrayList<URL> list = new ArrayList<URL>();
        for (Object o : this.servletContext.getResourcePaths(BUNDLES_DIR)) {
            URL url;
            String name = (String)o;
            if (!name.endsWith(".jar") || (url = this.servletContext.getResource(name)) == null) continue;
            list.add(url);
        }
        ProtectionDomain protectionDomain = ShellService.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL loc = codeSource.getLocation();
        list.add(loc);
        return list;
    }

    @Override
    protected void addSpringOSGiSupport() {
        block4: {
            try {
                Class<?> clazz = Class.forName("org.springframework.osgi.web.context.support.OsgiBundleXmlWebApplicationContext");
                String key = (String)clazz.getDeclaredField("BUNDLE_CONTEXT_ATTRIBUTE").get(null);
                this.servletContext.setAttribute(key, (Object)this.bctx);
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Spring OSGi support is not enabled", new String[0]);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error("The API of Spring OSGi has changed and the field [#0] is no longer available. The OSGi plugin needs to be updated", (Throwable)e, new String[]{"org.springframework.osgi.web.context.support.OsgiBundleXmlWebApplicationContext.BUNDLE_CONTEXT_ATTRIBUTE"});
            }
        }
    }

    @Override
    public Map<String, Bundle> getBundles() {
        HashMap<String, Bundle> bundles = new HashMap<String, Bundle>();
        for (Bundle bundle : this.bctx.getBundles()) {
            bundles.put(bundle.getSymbolicName(), bundle);
        }
        return Collections.unmodifiableMap(bundles);
    }

    @Override
    public Map<String, Bundle> getActiveBundles() {
        HashMap<String, Bundle> bundles = new HashMap<String, Bundle>();
        for (Bundle bundle : this.bctx.getBundles()) {
            if (bundle.getState() != 32) continue;
            bundles.put(bundle.getSymbolicName(), bundle);
        }
        return Collections.unmodifiableMap(bundles);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bctx;
    }

    @Override
    public void destroy() throws Exception {
    }
}

