/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import java.util.Map;
import org.apache.struts2.osgi.BundleAccessor;
import org.apache.struts2.osgi.OsgiUtil;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringOsgiObjectFactory
extends ObjectFactory {
    private static final String SPRING_SERVICE_NAME = "org.springframework.context.ApplicationContext";
    private BundleAccessor bundleAccessor;

    public Object buildBean(String className, Map<String, Object> extraContext, boolean injectInternal) throws Exception {
        if (this.containsBean(className)) {
            return this.getBean(className);
        }
        Class clazz = ClassLoaderUtil.loadClass((String)className, SpringOsgiObjectFactory.class);
        Object object = clazz.newInstance();
        if (injectInternal) {
            this.injectInternalBeans(object);
        }
        return object;
    }

    public Object buildBean(Class clazz, Map<String, Object> extraContext) throws Exception {
        return clazz.newInstance();
    }

    public Class getClassInstance(String className) throws ClassNotFoundException {
        return this.containsBean(className) ? this.getBean(className).getClass() : ClassLoaderUtil.loadClass((String)className, SpringOsgiObjectFactory.class);
    }

    protected Object getBean(String beanName) {
        ServiceReference[] refs = this.bundleAccessor.getAllServiceReferences(SPRING_SERVICE_NAME);
        if (refs != null) {
            for (ServiceReference ref : refs) {
                Object context = this.bundleAccessor.getService(ref);
                if (!OsgiUtil.containsBean(context, beanName)) continue;
                return OsgiUtil.getBean(context, beanName);
            }
        }
        return null;
    }

    protected boolean containsBean(String beanName) {
        ServiceReference[] refs = this.bundleAccessor.getAllServiceReferences(SPRING_SERVICE_NAME);
        if (refs != null) {
            for (ServiceReference ref : refs) {
                Object context = this.bundleAccessor.getService(ref);
                if (!OsgiUtil.containsBean(context, beanName)) continue;
                return true;
            }
        }
        return false;
    }

    @Inject
    public void setBundleAccessor(BundleAccessor bundleAccessor) {
        this.bundleAccessor = bundleAccessor;
    }
}

