/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi;

import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.util.URLUtil;
import com.opensymphony.xwork2.util.finder.ResourceFinder;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.framework.Felix;
import org.apache.felix.main.AutoActivator;
import org.apache.felix.main.Main;
import org.apache.felix.shell.ShellService;
import org.apache.struts2.StrutsException;
import org.apache.struts2.osgi.OsgiHost;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FelixOsgiHost
implements OsgiHost {
    private static final Logger LOG = LoggerFactory.getLogger(FelixOsgiHost.class);
    private Felix felix;
    private static final Pattern versionPattern = Pattern.compile("([\\d])+[\\.-]");
    private ServletContext servletContext;

    protected void startFelix() {
        String cleanBundleCache;
        Properties configProps = this.getProperties("default.properties");
        Main.copySystemProperties((Properties)configProps);
        this.replaceSystemPackages(configProps);
        Properties strutsConfigProps = this.getProperties("struts-osgi.properties");
        this.addExportedPackages(strutsConfigProps, configProps);
        this.addAutoStartBundles(configProps);
        String storageDir = System.getProperty("java.io.tmpdir") + ".felix-cache";
        configProps.setProperty("org.osgi.framework.storage", storageDir);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Storing bundles at [#0]", new String[]{storageDir});
        }
        if ("true".equalsIgnoreCase(cleanBundleCache = this.getServletContextParam("struts.osgi.clearBundleCache", "true"))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Clearing bundle cache", new String[0]);
            }
            configProps.put("org.osgi.framework.storage.clean", "onFirstInit");
        }
        configProps.put("felix.service.urlhandlers", "false");
        configProps.put("felix.log.level", this.getServletContextParam("struts.osgi.logLevel", "1"));
        configProps.put("Bundle-ClassPath", ".");
        configProps.put("org.osgi.framework.startlevel", this.getServletContextParam("struts.osgi.runLevel", "3"));
        try {
            ArrayList<AutoActivator> list = new ArrayList<AutoActivator>();
            list.add(new AutoActivator((Map)configProps));
            configProps.put("felix.systembundle.activators", list);
            this.felix = new Felix((Map)configProps);
            this.felix.start();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Apache Felix is running", new String[0]);
            }
        }
        catch (Exception ex) {
            throw new ConfigurationException("Couldn't start Apache Felix", (Throwable)ex);
        }
        this.addSpringOSGiSupport();
        this.servletContext.setAttribute("__struts_osgi_bundle_context", (Object)this.felix.getBundleContext());
    }

    private String getServletContextParam(String paramName, String defaultValue) {
        return StringUtils.defaultString((String)this.servletContext.getInitParameter(paramName), (String)defaultValue);
    }

    protected void addAutoStartBundles(Properties configProps) {
        ArrayList<String> bundleJarsLevel1 = new ArrayList<String>();
        bundleJarsLevel1.add(this.getJarUrl(ShellService.class));
        bundleJarsLevel1.add(this.getJarUrl(ServiceTracker.class));
        configProps.put("felix.auto.start.1", StringUtils.join(bundleJarsLevel1, (String)" "));
        Map<String, String> runLevels = this.getRunLevelDirs("bundles");
        if (runLevels.isEmpty()) {
            List<String> bundles = this.getBundlesInDir("bundles");
            if (!bundles.isEmpty()) {
                configProps.put("felix.auto.start.2", StringUtils.join(bundles, (String)" "));
            }
        } else {
            for (String runLevel : runLevels.keySet()) {
                if ("1".endsWith(runLevel)) {
                    throw new StrutsException("Run level dirs must be greater than 1. Run level 1 is reserved for the Felix bundles");
                }
                List<String> bundles = this.getBundlesInDir(runLevels.get(runLevel));
                configProps.put("felix.auto.start." + runLevel, StringUtils.join(bundles, (String)" "));
            }
        }
    }

    protected Map<String, String> getRunLevelDirs(String dir) {
        HashMap<String, String> dirs;
        block12: {
            dirs = new HashMap<String, String>();
            try {
                ResourceFinder finder = new ResourceFinder(new URL[0]);
                URL url = finder.find("bundles");
                if (url != null) {
                    if ("file".equals(url.getProtocol())) {
                        File bundlesDir = new File(url.toURI());
                        String[] runLevelDirs = bundlesDir.list(new FilenameFilter(){

                            public boolean accept(File file, String name) {
                                try {
                                    return file.isDirectory() && Integer.valueOf(name) > 0;
                                }
                                catch (NumberFormatException ex) {
                                    return false;
                                }
                            }
                        });
                        if (runLevelDirs != null && runLevelDirs.length > 0) {
                            for (String runLevel : runLevelDirs) {
                                dirs.put(runLevel, StringUtils.chomp((String)dir, (String)"/") + "/" + runLevel);
                            }
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug("No run level directories found under the [#0] directory", new String[]{dir});
                        }
                    } else if (LOG.isWarnEnabled()) {
                        LOG.warn("Unable to read [#0] directory", new String[]{dir});
                    }
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn("The [#0] directory was not found", new String[]{dir});
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block12;
                LOG.warn("Unable load bundles from the [#0] directory", (Throwable)e, new String[]{dir});
            }
        }
        return dirs;
    }

    protected List<String> getBundlesInDir(String dir) {
        ArrayList<String> bundleJars;
        block13: {
            bundleJars = new ArrayList<String>();
            try {
                ResourceFinder finder = new ResourceFinder(new URL[0]);
                URL url = finder.find(dir);
                if (url != null) {
                    if ("file".equals(url.getProtocol())) {
                        File bundlesDir = new File(url.toURI());
                        File[] bundles = bundlesDir.listFiles(new FilenameFilter(){

                            public boolean accept(File file, String name) {
                                return StringUtils.endsWith((String)name, (String)".jar");
                            }
                        });
                        if (bundles != null && bundles.length > 0) {
                            for (File bundle : bundles) {
                                String externalForm = bundle.toURI().toURL().toExternalForm();
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Adding bundle [#0]", new String[]{externalForm});
                                }
                                bundleJars.add(externalForm);
                            }
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug("No bundles found under the [#0] directory", new String[]{dir});
                        }
                    } else if (LOG.isWarnEnabled()) {
                        LOG.warn("Unable to read [#0] directory", new String[]{dir});
                    }
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn("The [#0] directory was not found", new String[]{dir});
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block13;
                LOG.warn("Unable load bundles from the [#0] directory", (Throwable)e, new String[]{dir});
            }
        }
        return bundleJars;
    }

    protected void addSpringOSGiSupport() {
        block4: {
            try {
                Class<?> clazz = Class.forName("org.springframework.osgi.web.context.support.OsgiBundleXmlWebApplicationContext");
                String key = (String)clazz.getDeclaredField("BUNDLE_CONTEXT_ATTRIBUTE").get(null);
                this.servletContext.setAttribute(key, (Object)this.felix.getBundleContext());
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Spring OSGi support is not enabled", new String[0]);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error("The API of Spring OSGi has changed and the field [#0] is no longer available. The OSGi plugin needs to be updated", (Throwable)e, new String[]{"org.springframework.osgi.web.context.support.OsgiBundleXmlWebApplicationContext.BUNDLE_CONTEXT_ATTRIBUTE"});
            }
        }
    }

    protected String getJarUrl(Class clazz) {
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL loc = codeSource.getLocation();
        return loc.toString();
    }

    protected void replaceSystemPackages(Properties properties) {
        String systemPackages = (String)properties.get("org.osgi.framework.system.packages");
        String jreVersion = "jre-" + System.getProperty("java.version").substring(0, 3);
        systemPackages = systemPackages.replace("${jre-${java.specification.version}}", (String)properties.get(jreVersion));
        properties.put("org.osgi.framework.system.packages", systemPackages);
    }

    protected void addExportedPackages(Properties strutsConfigProps, Properties configProps) {
        String[] rootPackages = StringUtils.split((String)((String)strutsConfigProps.get("scanning.package.includes")), (String)",");
        ResourceFinder finder = new ResourceFinder("");
        ArrayList<String> exportedPackages = new ArrayList<String>();
        for (String rootPackage : rootPackages) {
            try {
                String version = null;
                if (rootPackage.indexOf(";") > 0) {
                    String[] splitted = rootPackage.split(";");
                    rootPackage = splitted[0];
                    version = splitted[1];
                }
                Map subpackagesMap = finder.findPackagesMap(StringUtils.replace((String)rootPackage.trim(), (String)".", (String)"/"));
                for (Map.Entry entry : subpackagesMap.entrySet()) {
                    URL url = (URL)entry.getKey();
                    Set packages = (Set)entry.getValue();
                    if (StringUtils.isBlank((String)version)) {
                        version = this.getVersion(url);
                    }
                    if (packages == null) continue;
                    for (String subpackage : packages) {
                        exportedPackages.add(subpackage + "; version=" + version);
                    }
                }
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("Unable to find subpackages of [#0]", (Throwable)e, new String[]{rootPackage});
            }
        }
        if (!exportedPackages.isEmpty()) {
            String systemPackages = (String)configProps.get("org.osgi.framework.system.packages");
            systemPackages = StringUtils.chomp((String)systemPackages, (String)",") + "," + StringUtils.join(exportedPackages, (String)",");
            configProps.put("org.osgi.framework.system.packages", systemPackages);
        }
    }

    protected String getVersion(URL url) {
        block5: {
            if ("jar".equals(url.getProtocol())) {
                try {
                    JarFile jarFile = new JarFile(new File(URLUtil.normalizeToFileProtocol((URL)url).toURI()));
                    Manifest manifest = jarFile.getManifest();
                    if (manifest != null) {
                        String version = manifest.getMainAttributes().getValue("Bundle-Version");
                        if (StringUtils.isNotBlank((String)version)) {
                            return FelixOsgiHost.getVersionFromString(version);
                        }
                        break block5;
                    }
                    return FelixOsgiHost.getVersionFromString(jarFile.getName());
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block5;
                    LOG.error("Unable to extract version from [#0], defaulting to '1.0.0'", new String[]{url.toExternalForm()});
                }
            }
        }
        return "1.0.0";
    }

    protected static String getVersionFromString(String str) {
        Matcher matcher = versionPattern.matcher(str);
        ArrayList<String> parts = new ArrayList<String>();
        while (matcher.find()) {
            parts.add(matcher.group(1));
        }
        if (parts.size() == 0) {
            return "1.0.0";
        }
        while (parts.size() < 3) {
            parts.add("0");
        }
        return StringUtils.join(parts, (String)".");
    }

    protected Properties getProperties(String fileName) {
        ResourceFinder finder = new ResourceFinder("");
        try {
            return finder.findProperties(fileName);
        }
        catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Unable to read property file [#]", new String[]{fileName});
            }
            return new Properties();
        }
    }

    @Override
    public Map<String, Bundle> getBundles() {
        HashMap<String, Bundle> bundles = new HashMap<String, Bundle>();
        for (Bundle bundle : this.felix.getBundleContext().getBundles()) {
            bundles.put(bundle.getSymbolicName(), bundle);
        }
        return Collections.unmodifiableMap(bundles);
    }

    @Override
    public Map<String, Bundle> getActiveBundles() {
        HashMap<String, Bundle> bundles = new HashMap<String, Bundle>();
        for (Bundle bundle : this.felix.getBundleContext().getBundles()) {
            if (bundle.getState() != 32) continue;
            bundles.put(bundle.getSymbolicName(), bundle);
        }
        return Collections.unmodifiableMap(bundles);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.felix.getBundleContext();
    }

    @Override
    public void destroy() throws Exception {
        this.felix.stop();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Apache Felix has stopped", new String[0]);
        }
    }

    @Override
    public void init(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.startFelix();
    }
}

