/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.convention;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.ExceptionMappingConfig;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.AnnotationUtils;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.WildcardHelper;
import com.opensymphony.xwork2.util.classloader.ReloadingClassLoader;
import com.opensymphony.xwork2.util.finder.ClassFinder;
import com.opensymphony.xwork2.util.finder.ClassFinderFactory;
import com.opensymphony.xwork2.util.finder.ClassLoaderInterface;
import com.opensymphony.xwork2.util.finder.ClassLoaderInterfaceDelegate;
import com.opensymphony.xwork2.util.finder.Test;
import com.opensymphony.xwork2.util.finder.UrlSet;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.StrutsException;
import org.apache.struts2.convention.ActionConfigBuilder;
import org.apache.struts2.convention.ActionNameBuilder;
import org.apache.struts2.convention.DefaultClassFinder;
import org.apache.struts2.convention.InterceptorMapBuilder;
import org.apache.struts2.convention.ReflectionTools;
import org.apache.struts2.convention.ResultMapBuilder;
import org.apache.struts2.convention.StringTools;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Actions;
import org.apache.struts2.convention.annotation.AllowedMethods;
import org.apache.struts2.convention.annotation.DefaultInterceptorRef;
import org.apache.struts2.convention.annotation.ExceptionMapping;
import org.apache.struts2.convention.annotation.ExceptionMappings;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.Namespaces;
import org.apache.struts2.convention.annotation.ParentPackage;

public class PackageBasedActionConfigBuilder
implements ActionConfigBuilder {
    private static final Logger LOG = LogManager.getLogger(PackageBasedActionConfigBuilder.class);
    private static final boolean EXTRACT_BASE_INTERFACES = true;
    private final Configuration configuration;
    private final ActionNameBuilder actionNameBuilder;
    private final ResultMapBuilder resultMapBuilder;
    private final InterceptorMapBuilder interceptorMapBuilder;
    private final ObjectFactory objectFactory;
    private final String defaultParentPackage;
    private final boolean redirectToSlash;
    private String[] actionPackages;
    private String[] excludePackages;
    private String[] packageLocators;
    private String[] includeJars;
    private String packageLocatorsBasePackage;
    private boolean disableActionScanning = false;
    private boolean disablePackageLocatorsScanning = false;
    private Set<String> actionSuffix = Collections.singleton("Action");
    private boolean checkImplementsAction = true;
    private boolean mapAllMatches = false;
    private Set<String> loadedFileUrls = new HashSet<String>();
    private boolean devMode;
    private ReloadingClassLoader reloadingClassLoader;
    private boolean reload;
    private Set<String> fileProtocols;
    private boolean alwaysMapExecute;
    private boolean excludeParentClassLoader;
    private boolean slashesInActionNames;
    private static final String DEFAULT_METHOD = "execute";
    private boolean eagerLoading = false;
    private FileManager fileManager;
    private ClassFinderFactory classFinderFactory;

    @Inject
    public PackageBasedActionConfigBuilder(Configuration configuration, Container container, ObjectFactory objectFactory, @Inject(value="struts.convention.redirect.to.slash") String redirectToSlash, @Inject(value="struts.convention.default.parent.package") String defaultParentPackage) {
        this.configuration = configuration;
        this.actionNameBuilder = (ActionNameBuilder)container.getInstance(ActionNameBuilder.class, (String)container.getInstance(String.class, "struts.convention.actionNameBuilder"));
        this.resultMapBuilder = (ResultMapBuilder)container.getInstance(ResultMapBuilder.class, (String)container.getInstance(String.class, "struts.convention.resultMapBuilder"));
        this.interceptorMapBuilder = (InterceptorMapBuilder)container.getInstance(InterceptorMapBuilder.class, (String)container.getInstance(String.class, "struts.convention.interceptorMapBuilder"));
        this.objectFactory = objectFactory;
        this.redirectToSlash = Boolean.parseBoolean(redirectToSlash);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Setting action default parent package to [{}]", (Object)defaultParentPackage);
        }
        this.defaultParentPackage = defaultParentPackage;
    }

    @Inject(value="struts.devMode")
    public void setDevMode(String mode) {
        this.devMode = BooleanUtils.toBoolean((String)mode);
    }

    @Inject(value="struts.convention.classes.reload")
    public void setReload(String reload) {
        this.reload = BooleanUtils.toBoolean((String)reload);
    }

    @Inject(value="struts.enable.SlashesInActionNames")
    public void setSlashesInActionNames(String slashesInActionNames) {
        this.slashesInActionNames = BooleanUtils.toBoolean((String)slashesInActionNames);
    }

    @Inject(value="struts.convention.exclude.parentClassLoader")
    public void setExcludeParentClassLoader(String exclude) {
        this.excludeParentClassLoader = BooleanUtils.toBoolean((String)exclude);
    }

    @Inject(value="struts.convention.action.alwaysMapExecute")
    public void setAlwaysMapExecute(String alwaysMapExecute) {
        this.alwaysMapExecute = BooleanUtils.toBoolean((String)alwaysMapExecute);
    }

    @Inject(value="struts.convention.action.fileProtocols")
    public void setFileProtocols(String fileProtocols) {
        if (StringUtils.isNotBlank((CharSequence)fileProtocols)) {
            this.fileProtocols = TextParseUtil.commaDelimitedStringToSet((String)fileProtocols);
        }
    }

    @Inject(value="struts.convention.action.disableScanning", required=false)
    public void setDisableActionScanning(String disableActionScanning) {
        this.disableActionScanning = BooleanUtils.toBoolean((String)disableActionScanning);
    }

    @Inject(value="struts.convention.action.includeJars", required=false)
    public void setIncludeJars(String includeJars) {
        if (StringUtils.isNotEmpty((CharSequence)includeJars)) {
            this.includeJars = includeJars.split("\\s*[,]\\s*");
        }
    }

    @Inject(value="struts.convention.package.locators.disable", required=false)
    public void setDisablePackageLocatorsScanning(String disablePackageLocatorsScanning) {
        this.disablePackageLocatorsScanning = BooleanUtils.toBoolean((String)disablePackageLocatorsScanning);
    }

    @Inject(value="struts.convention.action.packages", required=false)
    public void setActionPackages(String actionPackages) {
        if (StringUtils.isNotBlank((CharSequence)actionPackages)) {
            this.actionPackages = actionPackages.split("\\s*[,]\\s*");
        }
    }

    @Inject(value="struts.convention.action.checkImplementsAction", required=false)
    public void setCheckImplementsAction(String checkImplementsAction) {
        this.checkImplementsAction = BooleanUtils.toBoolean((String)checkImplementsAction);
    }

    @Inject(value="struts.convention.action.suffix", required=false)
    public void setActionSuffix(String actionSuffix) {
        if (StringUtils.isNotBlank((CharSequence)actionSuffix)) {
            this.actionSuffix = TextParseUtil.commaDelimitedStringToSet((String)actionSuffix);
        }
    }

    @Inject(value="struts.convention.exclude.packages", required=false)
    public void setExcludePackages(String excludePackages) {
        if (StringUtils.isNotBlank((CharSequence)excludePackages)) {
            this.excludePackages = excludePackages.split("\\s*[,]\\s*");
        }
    }

    @Inject(value="struts.convention.package.locators", required=false)
    public void setPackageLocators(String packageLocators) {
        this.packageLocators = packageLocators.split("\\s*[,]\\s*");
    }

    @Inject(value="struts.convention.package.locators.basePackage", required=false)
    public void setPackageLocatorsBase(String packageLocatorsBasePackage) {
        this.packageLocatorsBasePackage = packageLocatorsBasePackage;
    }

    @Inject(value="struts.convention.action.mapAllMatches", required=false)
    public void setMapAllMatches(String mapAllMatches) {
        this.mapAllMatches = BooleanUtils.toBoolean((String)mapAllMatches);
    }

    @Inject(value="struts.convention.action.eagerLoading", required=false)
    public void setEagerLoading(String eagerLoading) {
        this.eagerLoading = BooleanUtils.toBoolean((String)eagerLoading);
    }

    @Inject
    public void setFileManagerFactory(FileManagerFactory fileManagerFactory) {
        this.fileManager = fileManagerFactory.getFileManager();
    }

    @Inject(required=false)
    public void setClassFinderFactory(ClassFinderFactory classFinderFactory) {
        this.classFinderFactory = classFinderFactory;
    }

    protected void initReloadClassLoader() {
        if (this.isReloadEnabled() && this.reloadingClassLoader == null) {
            this.reloadingClassLoader = new ReloadingClassLoader(this.getClassLoader());
        }
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public void buildActionConfigs() {
        this.initReloadClassLoader();
        if (!this.disableActionScanning) {
            if (this.actionPackages == null && this.packageLocators == null) {
                throw new ConfigurationException("At least a list of action packages or action package locators must be given using one of the properties [struts.convention.action.packages] or [struts.convention.package.locators]");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Loading action configurations");
                if (this.actionPackages != null) {
                    LOG.trace("Actions being loaded from action packages: {}", (Object[])this.actionPackages);
                }
                if (this.packageLocators != null) {
                    LOG.trace("Actions being loaded using package locator's: {}", (Object[])this.packageLocators);
                }
                if (this.excludePackages != null) {
                    LOG.trace("Excluding actions from packages: {}", (Object[])this.excludePackages);
                }
            }
            Set<Class> classes = this.findActions();
            this.buildConfiguration(classes);
        }
    }

    protected ClassLoaderInterface getClassLoaderInterface() {
        if (this.isReloadEnabled()) {
            return new ClassLoaderInterfaceDelegate((ClassLoader)this.reloadingClassLoader);
        }
        ClassLoaderInterface classLoaderInterface = null;
        ActionContext ctx = ActionContext.getContext();
        if (ctx != null) {
            classLoaderInterface = (ClassLoaderInterface)ctx.get("__current_class_loader_interface");
        }
        return (ClassLoaderInterface)ObjectUtils.defaultIfNull((Object)classLoaderInterface, (Object)new ClassLoaderInterfaceDelegate(this.getClassLoader()));
    }

    protected boolean isReloadEnabled() {
        return this.devMode && this.reload;
    }

    protected Set<Class> findActions() {
        HashSet<Class> classes = new HashSet<Class>();
        try {
            if (this.actionPackages != null || this.packageLocators != null && !this.disablePackageLocatorsScanning) {
                Test<String> classPackageTest = this.getClassPackageTest();
                List<URL> urls = this.readUrls();
                ClassFinder finder = this.buildClassFinder(classPackageTest, urls);
                Test<ClassFinder.ClassInfo> test = this.getActionClassTest();
                classes.addAll(finder.findClasses(test));
            }
        }
        catch (Exception ex) {
            LOG.error("Unable to scan named packages", (Throwable)ex);
        }
        return classes;
    }

    protected ClassFinder buildClassFinder(Test<String> classPackageTest, List<URL> urls) {
        if (this.classFinderFactory != null) {
            LOG.trace("Using ClassFinderFactory to create instance of ClassFinder!");
            return this.classFinderFactory.buildClassFinder(this.getClassLoaderInterface(), urls, true, this.fileProtocols, classPackageTest);
        }
        LOG.trace("ClassFinderFactory not defined, fallback to default ClassFinder implementation");
        return new DefaultClassFinder(this.getClassLoaderInterface(), urls, true, this.fileProtocols, classPackageTest);
    }

    private List<URL> readUrls() throws IOException {
        ArrayList<URL> resourceUrls = new ArrayList<URL>();
        ArrayList<URL> classesList = Collections.list(this.getClassLoaderInterface().getResources(""));
        for (URL url : classesList) {
            resourceUrls.addAll(this.fileManager.getAllPhysicalUrls(url));
        }
        return this.buildUrlSet(resourceUrls).getUrls();
    }

    private UrlSet buildUrlSet(List<URL> resourceUrls) throws IOException {
        ClassLoaderInterface classLoaderInterface = this.getClassLoaderInterface();
        UrlSet urlSet = new UrlSet(resourceUrls);
        urlSet = urlSet.include(new UrlSet(classLoaderInterface, this.fileProtocols));
        if (this.excludeParentClassLoader) {
            ClassLoaderInterface parent = classLoaderInterface.getParent();
            if (parent != null && this.isReloadEnabled()) {
                parent = parent.getParent();
            }
            if (parent != null) {
                urlSet = urlSet.exclude(parent);
            }
            try {
                ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                urlSet = urlSet.exclude((ClassLoaderInterface)new ClassLoaderInterfaceDelegate(systemClassLoader.getParent()));
            }
            catch (SecurityException e) {
                LOG.warn("Could not get the system classloader due to security constraints, there may be improper urls left to scan");
            }
        }
        urlSet = urlSet.includeClassesUrl(classLoaderInterface, new UrlSet.FileProtocolNormalizer(){

            public URL normalizeToFileProtocol(URL url) {
                return PackageBasedActionConfigBuilder.this.fileManager.normalizeToFileProtocol(url);
            }
        });
        urlSet = urlSet.excludeJavaExtDirs().excludeJavaEndorsedDirs().excludeUserExtensionsDir();
        try {
            urlSet = urlSet.excludeJavaHome();
        }
        catch (NullPointerException e) {
            LOG.warn("Could not exclude JAVA_HOME, is this a sandbox jvm?");
        }
        urlSet = urlSet.excludePaths(System.getProperty("sun.boot.class.path", ""));
        urlSet = urlSet.exclude(".*/JavaVM.framework/.*");
        if (this.includeJars != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("jar urls regexes were specified: {}", Arrays.asList(this.includeJars));
            }
            List rawIncludedUrls = urlSet.getUrls();
            HashSet<URL> includeUrls = new HashSet<URL>();
            boolean[] patternUsed = new boolean[this.includeJars.length];
            block4: for (URL url : rawIncludedUrls) {
                if (this.fileProtocols.contains(url.getProtocol())) {
                    for (int i = 0; i < this.includeJars.length; ++i) {
                        String includeJar = this.includeJars[i];
                        if (!Pattern.matches(includeJar, url.toExternalForm())) continue;
                        includeUrls.add(url);
                        patternUsed[i] = true;
                        continue block4;
                    }
                    continue;
                }
                LOG.debug("It is not a jar [{}]", (Object)url);
                includeUrls.add(url);
            }
            if (LOG.isWarnEnabled()) {
                for (int i = 0; i < patternUsed.length; ++i) {
                    if (patternUsed[i]) continue;
                    LOG.warn("The includeJars pattern [{}] did not match any jars in the classpath", (Object)this.includeJars[i]);
                }
            }
            return new UrlSet(includeUrls);
        }
        urlSet = urlSet.exclude(".*?\\.jar(!/|/)?");
        return urlSet;
    }

    protected boolean includeClassNameInActionScan(String className) {
        String classPackageName = StringUtils.substringBeforeLast((String)className, (String)".");
        return (this.checkActionPackages(classPackageName) || this.checkPackageLocators(classPackageName)) && this.checkExcludePackages(classPackageName);
    }

    protected boolean checkExcludePackages(String classPackageName) {
        if (this.excludePackages != null && this.excludePackages.length > 0) {
            WildcardHelper wildcardHelper = new WildcardHelper();
            HashMap matchMap = new HashMap();
            for (String packageExclude : this.excludePackages) {
                int[] packagePattern = wildcardHelper.compilePattern(packageExclude);
                if (!wildcardHelper.match(matchMap, classPackageName, packagePattern)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkActionPackages(String classPackageName) {
        if (this.actionPackages != null) {
            for (String packageName : this.actionPackages) {
                String strictPackageName = packageName + ".";
                if (!classPackageName.equals(packageName) && !classPackageName.startsWith(strictPackageName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkPackageLocators(String classPackageName) {
        if (this.packageLocators != null && !this.disablePackageLocatorsScanning && classPackageName.length() > 0 && (this.packageLocatorsBasePackage == null || classPackageName.startsWith(this.packageLocatorsBasePackage))) {
            for (String packageLocator : this.packageLocators) {
                String[] splitted = classPackageName.split("\\.");
                if (!StringTools.contains(splitted, packageLocator, false)) continue;
                return true;
            }
        }
        return false;
    }

    protected Test<String> getClassPackageTest() {
        return new Test<String>(){

            public boolean test(String className) {
                return PackageBasedActionConfigBuilder.this.includeClassNameInActionScan(className);
            }
        };
    }

    protected Test<ClassFinder.ClassInfo> getActionClassTest() {
        return new Test<ClassFinder.ClassInfo>(){

            public boolean test(ClassFinder.ClassInfo classInfo) {
                boolean inPackage = PackageBasedActionConfigBuilder.this.includeClassNameInActionScan(classInfo.getName());
                boolean nameMatches = this.matchesSuffix(classInfo.getName());
                try {
                    return inPackage && (nameMatches || PackageBasedActionConfigBuilder.this.checkImplementsAction && com.opensymphony.xwork2.Action.class.isAssignableFrom(classInfo.get()));
                }
                catch (ClassNotFoundException ex) {
                    LOG.error("Unable to load class [{}]", (Object)classInfo.getName(), (Object)ex);
                    return false;
                }
            }

            private boolean matchesSuffix(String name) {
                for (String suffix : PackageBasedActionConfigBuilder.this.actionSuffix) {
                    if (!name.endsWith(suffix)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    protected void buildConfiguration(Set<Class> classes) {
        HashMap<String, PackageConfig.Builder> packageConfigs = new HashMap<String, PackageConfig.Builder>();
        for (Class actionClass : classes) {
            Actions actionsAnnotation = actionClass.getAnnotation(Actions.class);
            Action actionAnnotation = actionClass.getAnnotation(Action.class);
            if (this.cannotInstantiate(actionClass)) {
                LOG.trace("Class [{}] did not pass the instantiation test and will be ignored", (Object)actionClass.getName());
                continue;
            }
            if (this.eagerLoading) {
                try {
                    this.objectFactory.getClassInstance(actionClass.getName());
                }
                catch (ClassNotFoundException e) {
                    LOG.error("Object Factory was unable to load class [{}]", (Object)actionClass.getName(), (Object)e);
                    throw new StrutsException("Object Factory was unable to load class " + actionClass.getName(), (Throwable)e);
                }
            }
            String actionPackage = actionClass.getPackage().getName();
            LOG.debug("Processing class [{}] in package [{}]", (Object)actionClass.getName(), (Object)actionPackage);
            Set<String> allowedMethods = this.getAllowedMethods(actionClass);
            List<String> namespaces = this.determineActionNamespace(actionClass);
            for (String namespace : namespaces) {
                String methodName;
                String defaultActionName = this.determineActionName(actionClass);
                PackageConfig.Builder defaultPackageConfig = this.getPackageConfig(packageConfigs, namespace, actionPackage, actionClass, null);
                Map<String, List<Action>> map = this.getActionAnnotations(actionClass);
                HashSet<String> actionNames = new HashSet<String>();
                boolean hasDefaultMethod = ReflectionTools.containsMethod(actionClass, DEFAULT_METHOD, new Class[0]);
                if (!map.containsKey(DEFAULT_METHOD) && hasDefaultMethod && actionAnnotation == null && actionsAnnotation == null && (this.alwaysMapExecute || map.isEmpty())) {
                    boolean found = false;
                    for (List<Action> actions : map.values()) {
                        for (Action action : actions) {
                            String actionName;
                            String string = actionName = action.value().equals("DEFAULT_VALUE") ? defaultActionName : action.value();
                            if (actionNames.contains(actionName)) {
                                throw new ConfigurationException("The action class [" + actionClass + "] contains two methods with an action name annotation whose value " + "is the same (they both might be empty as well).");
                            }
                            actionNames.add(actionName);
                            if (!action.value().equals("DEFAULT_VALUE")) continue;
                            found = true;
                        }
                    }
                    if (!found) {
                        this.createActionConfig(defaultPackageConfig, actionClass, defaultActionName, DEFAULT_METHOD, null, allowedMethods);
                    }
                }
                for (Map.Entry<String, List<Action>> entry : map.entrySet()) {
                    String method = entry.getKey();
                    List<Action> actions = entry.getValue();
                    for (Action action : actions) {
                        PackageConfig.Builder pkgCfg = defaultPackageConfig;
                        if (action.value().contains("/") && !this.slashesInActionNames) {
                            pkgCfg = this.getPackageConfig(packageConfigs, namespace, actionPackage, actionClass, action);
                        }
                        this.createActionConfig(pkgCfg, actionClass, defaultActionName, method, action, allowedMethods);
                    }
                }
                if (map.isEmpty() && this.mapAllMatches && actionAnnotation == null && actionsAnnotation == null) {
                    this.createActionConfig(defaultPackageConfig, actionClass, defaultActionName, null, actionAnnotation, allowedMethods);
                }
                String string = methodName = hasDefaultMethod ? DEFAULT_METHOD : null;
                if (actionsAnnotation != null) {
                    List<Action> actionAnnotations = this.checkActionsAnnotation(actionsAnnotation);
                    for (Action actionAnnotation2 : actionAnnotations) {
                        this.createActionConfig(defaultPackageConfig, actionClass, defaultActionName, methodName, actionAnnotation2, allowedMethods);
                    }
                    continue;
                }
                if (actionAnnotation == null) continue;
                this.createActionConfig(defaultPackageConfig, actionClass, defaultActionName, methodName, actionAnnotation, allowedMethods);
            }
        }
        this.buildIndexActions(packageConfigs);
        Set packageNames = packageConfigs.keySet();
        for (String packageName : packageNames) {
            this.configuration.addPackageConfig(packageName, ((PackageConfig.Builder)packageConfigs.get(packageName)).build());
        }
    }

    private Set<String> getAllowedMethods(Class<?> actionClass) {
        List annotations = AnnotationUtils.findAnnotations(actionClass, AllowedMethods.class);
        if (annotations == null || annotations.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> methods = new HashSet<String>();
        for (AllowedMethods allowedMethods : annotations) {
            methods.addAll(Arrays.asList(allowedMethods.value()));
        }
        return methods;
    }

    protected boolean cannotInstantiate(Class<?> actionClass) {
        return actionClass.isAnnotation() || actionClass.isInterface() || actionClass.isEnum() || (actionClass.getModifiers() & 0x400) != 0 || actionClass.isAnonymousClass();
    }

    protected List<String> determineActionNamespace(Class<?> actionClass) {
        int indexOfDot;
        Namespaces namespacesAnnotation;
        ArrayList<String> namespaces = new ArrayList<String>();
        Namespace namespaceAnnotation = (Namespace)AnnotationUtils.findAnnotation(actionClass, Namespace.class);
        if (namespaceAnnotation != null) {
            LOG.trace("Using non-default action namespace from Namespace annotation of [{}]", (Object)namespaceAnnotation.value());
            namespaces.add(namespaceAnnotation.value());
        }
        if ((namespacesAnnotation = (Namespaces)AnnotationUtils.findAnnotation(actionClass, Namespaces.class)) != null) {
            if (LOG.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                for (Namespace namespace : namespacesAnnotation.value()) {
                    sb.append(namespace.value()).append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                LOG.trace("Using non-default action namespaces from Namespaces annotation of [{}]", (Object)sb.toString());
            }
            for (Namespace namespace : namespacesAnnotation.value()) {
                namespaces.add(namespace.value());
            }
        }
        if (!namespaces.isEmpty()) {
            return namespaces;
        }
        String pkg = actionClass.getPackage().getName();
        String pkgPart = null;
        if (this.actionPackages != null) {
            for (String actionPackage : this.actionPackages) {
                if (!pkg.startsWith(actionPackage)) continue;
                pkgPart = actionClass.getName().substring(actionPackage.length() + 1);
            }
        }
        if (pkgPart == null && this.packageLocators != null) {
            for (String packageLocator : this.packageLocators) {
                int index = pkg.lastIndexOf("." + packageLocator + ".");
                if (index < 0 || index + packageLocator.length() != pkg.length() && index != 0 && (pkg.charAt(index) != '.' || pkg.charAt(index + 1 + packageLocator.length()) != '.')) continue;
                pkgPart = actionClass.getName().substring(index + packageLocator.length() + 2);
            }
        }
        if (pkgPart != null && (indexOfDot = pkgPart.lastIndexOf(46)) >= 0) {
            String convertedNamespace = this.actionNameBuilder.build(pkgPart.substring(0, indexOfDot));
            namespaces.add("/" + convertedNamespace.replace('.', '/'));
            return namespaces;
        }
        namespaces.add("");
        return namespaces;
    }

    protected String determineActionName(Class<?> actionClass) {
        String actionName = this.actionNameBuilder.build(actionClass.getSimpleName());
        LOG.trace("Got actionName for class [{}] of [{}]", (Object)actionClass.toString(), (Object)actionName);
        return actionName;
    }

    protected Map<String, List<Action>> getActionAnnotations(Class<?> actionClass) {
        Method[] methods = actionClass.getMethods();
        HashMap<String, List<Action>> map = new HashMap<String, List<Action>>();
        for (Method method : methods) {
            Actions actionsAnnotation = method.getAnnotation(Actions.class);
            if (actionsAnnotation != null) {
                List<Action> actions = this.checkActionsAnnotation(actionsAnnotation);
                map.put(method.getName(), actions);
                continue;
            }
            Action ann = method.getAnnotation(Action.class);
            if (ann == null) continue;
            map.put(method.getName(), Arrays.asList(ann));
        }
        return map;
    }

    protected List<Action> checkActionsAnnotation(Actions actionsAnnotation) {
        Action[] actionArray = actionsAnnotation.value();
        boolean valuelessSeen = false;
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Action ann : actionArray) {
            if (ann.value().equals("DEFAULT_VALUE") && !valuelessSeen) {
                valuelessSeen = true;
            } else if (ann.value().equals("DEFAULT_VALUE")) {
                throw new ConfigurationException("You may only add a single Action annotation that has no value parameter.");
            }
            actions.add(ann);
        }
        return actions;
    }

    protected void createActionConfig(PackageConfig.Builder pkgCfg, Class<?> actionClass, String actionName, String actionMethod, Action annotation, Set<String> allowedMethods) {
        ActionConfig existingActionConfig;
        ExceptionMappings exceptionMappings;
        String className = actionClass.getName();
        if (annotation != null) {
            actionName = annotation.value().equals("DEFAULT_VALUE") ? actionName : annotation.value();
            String string = actionName = StringUtils.contains((CharSequence)actionName, (CharSequence)"/") && !this.slashesInActionNames ? StringUtils.substringAfterLast((String)actionName, (String)"/") : actionName;
            if (!"DEFAULT_VALUE".equals(annotation.className())) {
                className = annotation.className();
            }
        }
        ActionConfig.Builder actionConfig = new ActionConfig.Builder(pkgCfg.getName(), actionName, className);
        actionConfig.methodName(actionMethod);
        if (pkgCfg.isStrictMethodInvocation()) {
            actionConfig.addAllowedMethod(actionMethod);
            actionConfig.addAllowedMethod(allowedMethods);
            actionConfig.addAllowedMethod((Collection)pkgCfg.getGlobalAllowedMethods());
        } else {
            actionConfig.addAllowedMethod("*");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating action config for class [{}], name [{}] and package name [{}] in namespace [{}]", (Object)actionClass.toString(), (Object)actionName, (Object)pkgCfg.getName(), (Object)pkgCfg.getNamespace());
        }
        List<InterceptorMapping> interceptors = this.interceptorMapBuilder.build(actionClass, pkgCfg, actionName, annotation);
        actionConfig.addInterceptors(interceptors);
        Map<String, ResultConfig> results = this.resultMapBuilder.build(actionClass, annotation, actionName, pkgCfg.build());
        actionConfig.addResultConfigs(results);
        if (annotation != null) {
            actionConfig.addParams(StringTools.createParameterMap(annotation.params()));
        }
        if (annotation != null) {
            actionConfig.addExceptionMappings(this.buildExceptionMappings(annotation.exceptionMappings(), actionName));
        }
        if ((exceptionMappings = actionClass.getAnnotation(ExceptionMappings.class)) != null) {
            actionConfig.addExceptionMappings(this.buildExceptionMappings(exceptionMappings.value(), actionName));
        }
        pkgCfg.addActionConfig(actionName, actionConfig.build());
        PackageConfig existingPkg = this.configuration.getPackageConfig(pkgCfg.getName());
        if (existingPkg != null && (existingActionConfig = (ActionConfig)existingPkg.getActionConfigs().get(actionName)) != null && LOG.isWarnEnabled()) {
            LOG.warn("Duplicated action definition in package [{}] with name [{}].", (Object)pkgCfg.getName(), (Object)actionName);
        }
        if (this.isReloadEnabled()) {
            URL classFile = actionClass.getResource(actionClass.getSimpleName() + ".class");
            this.fileManager.monitorFile(classFile);
            this.loadedFileUrls.add(classFile.toString());
        }
    }

    protected List<ExceptionMappingConfig> buildExceptionMappings(ExceptionMapping[] exceptions, String actionName) {
        ArrayList<ExceptionMappingConfig> exceptionMappings = new ArrayList<ExceptionMappingConfig>();
        for (ExceptionMapping exceptionMapping : exceptions) {
            LOG.trace("Mapping exception [{}] to result [{}] for action [{}]", (Object)exceptionMapping.exception(), (Object)exceptionMapping.result(), (Object)actionName);
            ExceptionMappingConfig.Builder builder = new ExceptionMappingConfig.Builder(null, exceptionMapping.exception(), exceptionMapping.result());
            builder.addParams(StringTools.createParameterMap(exceptionMapping.params()));
            exceptionMappings.add(builder.build());
        }
        return exceptionMappings;
    }

    protected PackageConfig.Builder getPackageConfig(Map<String, PackageConfig.Builder> packageConfigs, String actionNamespace, String actionPackage, Class<?> actionClass, Action action) {
        if (action != null && !action.value().equals("DEFAULT_VALUE")) {
            LOG.trace("Using non-default action namespace from the Action annotation of [{}]", (Object)action.value());
            String actionName = action.value();
            actionNamespace = StringUtils.contains((CharSequence)actionName, (CharSequence)"/") ? StringUtils.substringBeforeLast((String)actionName, (String)"/") : "";
        }
        ParentPackage parent = (ParentPackage)AnnotationUtils.findAnnotation(actionClass, ParentPackage.class);
        String parentName = null;
        if (parent != null) {
            LOG.trace("Using non-default parent package from annotation of [{}]", (Object)parent.value());
            parentName = parent.value();
        }
        if (parentName == null) {
            parentName = this.defaultParentPackage;
        }
        if (parentName == null) {
            throw new ConfigurationException("Unable to determine the parent XWork package for the action class [" + actionClass.getName() + "]");
        }
        PackageConfig parentPkg = this.configuration.getPackageConfig(parentName);
        if (parentPkg == null) {
            throw new ConfigurationException("Unable to locate parent package [" + parentName + "] for [" + actionClass + "]");
        }
        String name = actionPackage + "#" + parentPkg.getName() + "#" + actionNamespace;
        PackageConfig.Builder pkgConfig = packageConfigs.get(name);
        if (pkgConfig == null) {
            pkgConfig = new PackageConfig.Builder(name).namespace(actionNamespace).addParent(parentPkg);
            packageConfigs.put(name, pkgConfig);
            DefaultInterceptorRef defaultInterceptorRef = (DefaultInterceptorRef)AnnotationUtils.findAnnotation(actionClass, DefaultInterceptorRef.class);
            if (defaultInterceptorRef != null) {
                pkgConfig.defaultInterceptorRef(defaultInterceptorRef.value());
                LOG.trace("Setting [{}] as the default interceptor ref for [{}]", (Object)defaultInterceptorRef.value(), (Object)pkgConfig.getName());
            }
        }
        LOG.trace("Created package config named [{}] with a namespace [{}]", (Object)name, (Object)actionNamespace);
        return pkgConfig;
    }

    protected void buildIndexActions(Map<String, PackageConfig.Builder> packageConfigs) {
        HashMap<String, PackageConfig.Builder> byNamespace = new HashMap<String, PackageConfig.Builder>();
        Collection<PackageConfig.Builder> values = packageConfigs.values();
        for (PackageConfig.Builder packageConfig : values) {
            byNamespace.put(packageConfig.getNamespace(), packageConfig);
        }
        Set namespaces = byNamespace.keySet();
        for (String namespace : namespaces) {
            int lastSlash;
            PackageConfig.Builder pkgConfig = (PackageConfig.Builder)byNamespace.get(namespace);
            ActionConfig indexActionConfig = (ActionConfig)pkgConfig.build().getAllActionConfigs().get("index");
            if (indexActionConfig == null) continue;
            if (!this.redirectToSlash && (lastSlash = namespace.lastIndexOf(47)) >= 0) {
                String parentAction = namespace.substring(lastSlash + 1);
                String parentNamespace = namespace.substring(0, lastSlash);
                PackageConfig.Builder parent = (PackageConfig.Builder)byNamespace.get(parentNamespace);
                if (parent == null || parent.build().getAllActionConfigs().get(parentAction) == null) {
                    if (parent == null) {
                        parent = new PackageConfig.Builder(parentNamespace).namespace(parentNamespace).addParents(pkgConfig.build().getParents());
                        packageConfigs.put(parentNamespace, parent);
                    }
                    if (parent.build().getAllActionConfigs().get(parentAction) == null) {
                        parent.addActionConfig(parentAction, indexActionConfig);
                    }
                } else {
                    LOG.trace("The parent namespace [{}] already contains an action [{}]", (Object)parentNamespace, (Object)parentAction);
                }
            }
            if (pkgConfig.build().getAllActionConfigs().get("") != null) continue;
            LOG.trace("Creating index ActionConfig with an action name of [] for the action class [{}]", (Object)indexActionConfig.getClassName());
            pkgConfig.addActionConfig("", indexActionConfig);
        }
    }

    @Override
    public void destroy() {
        this.loadedFileUrls.clear();
    }

    @Override
    public boolean needsReload() {
        if (this.devMode && this.reload) {
            for (String url : this.loadedFileUrls) {
                if (!this.fileManager.fileNeedsReloading(url)) continue;
                LOG.debug("File [{}] changed, configuration will be reloaded", (Object)url);
                return true;
            }
            return false;
        }
        return false;
    }
}

