/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.convention;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.entities.InterceptorLocator;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.providers.InterceptorBuilder;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.location.Location;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.struts2.convention.InterceptorMapBuilder;
import org.apache.struts2.convention.StringTools;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.AnnotationTools;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInterceptorMapBuilder
implements InterceptorMapBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultInterceptorMapBuilder.class);
    private Configuration configuration;

    @Override
    public List<InterceptorMapping> build(Class<?> actionClass, PackageConfig.Builder builder, String actionName, Action annotation) {
        InterceptorRef[] interceptors;
        InterceptorRef interceptorRef;
        ArrayList<InterceptorMapping> interceptorList = new ArrayList<InterceptorMapping>(10);
        InterceptorRefs interceptorRefs = AnnotationTools.findAnnotation(actionClass, InterceptorRefs.class);
        if (interceptorRefs != null) {
            interceptorList.addAll(this.build(interceptorRefs.value(), actionName, builder));
        }
        if ((interceptorRef = AnnotationTools.findAnnotation(actionClass, InterceptorRef.class)) != null) {
            interceptorList.addAll(this.build(new InterceptorRef[]{interceptorRef}, actionName, builder));
        }
        if (annotation != null && (interceptors = annotation.interceptorRefs()) != null) {
            interceptorList.addAll(this.build(interceptors, actionName, builder));
        }
        return interceptorList;
    }

    protected List<InterceptorMapping> build(InterceptorRef[] interceptors, String actionName, PackageConfig.Builder builder) {
        ArrayList<InterceptorMapping> interceptorList = new ArrayList<InterceptorMapping>(10);
        for (InterceptorRef interceptor : interceptors) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Adding interceptor [#0] to [#1]", new String[]{interceptor.value(), actionName});
            }
            Map<String, String> params = StringTools.createParameterMap(interceptor.params());
            interceptorList.addAll(this.buildInterceptorList(builder, interceptor, params));
        }
        return interceptorList;
    }

    protected List<InterceptorMapping> buildInterceptorList(PackageConfig.Builder builder, InterceptorRef ref, Map params) {
        return InterceptorBuilder.constructInterceptorReference((InterceptorLocator)builder, (String)ref.value(), (Map)params, (Location)builder.build().getLocation(), (ObjectFactory)((ObjectFactory)this.configuration.getContainer().getInstance(ObjectFactory.class)));
    }

    @Inject
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

