/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.convention.classloader;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import org.apache.struts2.convention.classloader.ResourceStore;

public final class ResourceStoreClassLoader
extends ClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceStoreClassLoader.class);
    private final ResourceStore[] stores;

    public ResourceStoreClassLoader(ClassLoader pParent, ResourceStore[] pStores) {
        super(pParent);
        this.stores = new ResourceStore[pStores.length];
        System.arraycopy(pStores, 0, this.stores, 0, this.stores.length);
    }

    private Class fastFindClass(String name) {
        if (this.stores != null) {
            for (int i = 0; i < this.stores.length; ++i) {
                ResourceStore store = this.stores[i];
                byte[] clazzBytes = store.read(name.replace('.', '/') + ".class");
                if (clazzBytes == null) continue;
                return this.defineClass(name, clazzBytes, 0, clazzBytes.length);
            }
        }
        return null;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null && (clazz = this.fastFindClass(name)) == null) {
            ClassLoader parent = this.getParent();
            if (parent != null) {
                clazz = parent.loadClass(name);
            } else {
                throw new ClassNotFoundException(name);
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class clazz = this.fastFindClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }
}

