/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.convention.classloader;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.struts2.StrutsException;
import org.apache.struts2.convention.classloader.FileResourceStore;
import org.apache.struts2.convention.classloader.ResourceStore;
import org.apache.struts2.convention.classloader.ResourceStoreClassLoader;

public class ReloadingClassLoader
extends ClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadingClassLoader.class);
    private final ClassLoader parent;
    private ResourceStore[] stores;
    private ClassLoader delegate;

    public ReloadingClassLoader(ClassLoader pParent) {
        super(pParent);
        this.parent = pParent;
        URL root = pParent.getResource("/");
        try {
            this.stores = new ResourceStore[]{new FileResourceStore(new File(root.toURI()))};
        }
        catch (URISyntaxException e) {
            throw new StrutsException("Unable to start the reloadable class loader, consider setting 'struts.convention.classes.reload' to false", (Throwable)e);
        }
        this.delegate = new ResourceStoreClassLoader(this.parent, this.stores);
    }

    public boolean addResourceStore(ResourceStore pStore) {
        try {
            int n = this.stores.length;
            ResourceStore[] newStores = new ResourceStore[n + 1];
            System.arraycopy(this.stores, 0, newStores, 1, n);
            newStores[0] = pStore;
            this.stores = newStores;
            this.delegate = new ResourceStoreClassLoader(this.parent, this.stores);
            return true;
        }
        catch (RuntimeException e) {
            LOG.error("could not add resource store " + pStore, new String[0]);
            return false;
        }
    }

    public boolean removeResourceStore(ResourceStore pStore) {
        int i;
        int n = this.stores.length;
        for (i = 0; i < n && this.stores[i] != pStore; ++i) {
        }
        if (i == n) {
            return false;
        }
        ResourceStore[] newStores = new ResourceStore[n - 1];
        if (i > 0) {
            System.arraycopy(this.stores, 0, newStores, 0, i);
        }
        if (i < n - 1) {
            System.arraycopy(this.stores, i + 1, newStores, i, n - i - 1);
        }
        this.stores = newStores;
        this.delegate = new ResourceStoreClassLoader(this.parent, this.stores);
        return true;
    }

    public void reload() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reloading class loader", new String[0]);
        }
        this.delegate = new ResourceStoreClassLoader(this.parent, this.stores);
    }

    public void clearAssertionStatus() {
        this.delegate.clearAssertionStatus();
    }

    public URL getResource(String name) {
        return this.delegate.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.delegate.getResourceAsStream(name);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.delegate.loadClass(name);
    }

    public void setClassAssertionStatus(String className, boolean enabled) {
        this.delegate.setClassAssertionStatus(className, enabled);
    }

    public void setDefaultAssertionStatus(boolean enabled) {
        this.delegate.setDefaultAssertionStatus(enabled);
    }

    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.delegate.setPackageAssertionStatus(packageName, enabled);
    }
}

