/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.convention;

import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import com.opensymphony.xwork2.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.struts2.convention.ConventionsService;
import org.apache.struts2.convention.annotation.AnnotationTools;
import org.apache.struts2.convention.annotation.ResultPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConventionsServiceImpl
implements ConventionsService {
    private String resultPath;

    @Inject
    public ConventionsServiceImpl(@Inject(value="struts.convention.result.path") String resultPath) {
        this.resultPath = resultPath;
    }

    @Override
    public String determineResultPath(Class<?> actionClass) {
        String localResultPath = this.resultPath;
        ResultPath resultPathAnnotation = AnnotationTools.findAnnotation(actionClass, ResultPath.class);
        if (resultPathAnnotation != null) {
            if (resultPathAnnotation.value().equals("") && resultPathAnnotation.property().equals("")) {
                throw new ConfigurationException("The ResultPath annotation must have either a value or property specified.");
            }
            String property = resultPathAnnotation.property();
            if (property.equals("")) {
                localResultPath = resultPathAnnotation.value();
            } else {
                try {
                    ResourceBundle strutsBundle = ResourceBundle.getBundle("struts");
                    localResultPath = strutsBundle.getString(property);
                }
                catch (Exception e) {
                    throw new ConfigurationException("The action class [" + actionClass + "] defines" + " a @ResultPath annotation and a property definition however the" + " struts.properties could not be found in the classpath using ResourceBundle" + " OR the bundle exists but the property [" + property + "] is not defined" + " in the file.", (Throwable)e);
                }
            }
        }
        return localResultPath;
    }

    @Override
    public String determineResultPath(ActionConfig actionConfig) {
        if (actionConfig == null) {
            return this.resultPath;
        }
        try {
            return this.determineResultPath(Class.forName(actionConfig.getClassName()));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Invalid action class configuration that references an unknown class named [" + actionConfig.getClassName() + "]", e);
        }
    }

    @Override
    public Map<String, ResultTypeConfig> getResultTypesByExtension(PackageConfig packageConfig) {
        Map results = packageConfig.getAllResultTypeConfigs();
        HashMap<String, ResultTypeConfig> resultsByExtension = new HashMap<String, ResultTypeConfig>();
        resultsByExtension.put("jsp", (ResultTypeConfig)results.get("dispatcher"));
        resultsByExtension.put("vm", (ResultTypeConfig)results.get("velocity"));
        resultsByExtension.put("ftl", (ResultTypeConfig)results.get("freemarker"));
        resultsByExtension.put("html", (ResultTypeConfig)results.get("dispatcher"));
        resultsByExtension.put("htm", (ResultTypeConfig)results.get("dispatcher"));
        return resultsByExtension;
    }
}

