/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class DirectoryUtil {
    private DirectoryUtil() {
    }

    public static void copyDirectoryContents(final Path source, final Path destination) throws IOException {
        assert (source.getFileSystem().equals(destination.getFileSystem()));
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            private Path resolveTarget(Path other) {
                return destination.resolve(source.relativize(other));
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(this.resolveTarget(dir), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, this.resolveTarget(file), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

