/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.junit.rules.ExternalResource;

public abstract class SolrClientTestRule
extends ExternalResource {
    public void startSolr() {
        this.startSolr(LuceneTestCase.createTempDir((String)"solrhome"));
    }

    public abstract void startSolr(Path var1);

    public NewCollectionBuilder newCollection(String name) {
        return new NewCollectionBuilder(name);
    }

    public NewCollectionBuilder newCollection() {
        return new NewCollectionBuilder("collection1");
    }

    protected void create(NewCollectionBuilder b) throws SolrServerException, IOException {
        CoreAdminRequest.Create req = new CoreAdminRequest.Create();
        req.setCoreName(b.getName());
        req.setInstanceDir(b.getName());
        if (b.getConfigSet() != null) {
            req.setConfigSet(b.getConfigSet());
        }
        if (b.getConfigFile() != null) {
            req.setConfigName(b.getConfigFile());
        }
        if (b.getSchemaFile() != null) {
            req.setSchemaName(b.getSchemaFile());
        }
        if (b.getBasicAuthUser() != null) {
            req.setBasicAuthCredentials(b.getBasicAuthUser(), b.getBasicAuthPwd());
        }
        req.process(this.getAdminClient());
    }

    public SolrClient getAdminClient() {
        return this.getSolrClient(null);
    }

    public SolrClient getSolrClient() {
        return this.getSolrClient("collection1");
    }

    public abstract SolrClient getSolrClient(String var1);

    public void clearIndex() throws SolrServerException, IOException {
        new UpdateRequest().deleteByQuery("*:*").commit(this.getSolrClient(), null);
    }

    public class NewCollectionBuilder {
        private String name;
        private String configSet;
        private String configFile;
        private String schemaFile;
        private String basicAuthUser;
        private String basicAuthPwd;

        public NewCollectionBuilder(String name) {
            this.name = name;
        }

        public NewCollectionBuilder withConfigSet(String configSet) {
            String confSuffix;
            if (configSet != null && configSet.endsWith(confSuffix = FileSystems.getDefault().getSeparator() + "conf")) {
                configSet = configSet.substring(0, configSet.length() - confSuffix.length());
            }
            this.configSet = configSet;
            return this;
        }

        public NewCollectionBuilder withConfigFile(String configFile) {
            this.configFile = configFile;
            return this;
        }

        public NewCollectionBuilder withSchemaFile(String schemaFile) {
            this.schemaFile = schemaFile;
            return this;
        }

        public NewCollectionBuilder withBasicAuthCredentials(String user, String password) {
            this.basicAuthUser = user;
            this.basicAuthPwd = password;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public String getConfigSet() {
            return this.configSet;
        }

        public String getConfigFile() {
            return this.configFile;
        }

        public String getSchemaFile() {
            return this.schemaFile;
        }

        public void create() throws SolrServerException, IOException {
            SolrClientTestRule.this.create(this);
        }

        public String getBasicAuthUser() {
            return this.basicAuthUser;
        }

        public String getBasicAuthPwd() {
            return this.basicAuthPwd;
        }
    }
}

