/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.search.facet.AggValueSource;
import org.apache.solr.search.facet.CountAgg;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetModule;
import org.apache.solr.search.facet.SlotAcc;

class DebugAgg
extends AggValueSource {
    public static AtomicLong parses = new AtomicLong(0L);
    public final SolrParams localParams;
    public final AggValueSource inner;

    public DebugAgg(FunctionQParser fp) throws SyntaxError {
        super("debug");
        this.localParams = fp.getLocalParams();
        this.inner = fp.hasMoreArguments() ? fp.parseAgg(2) : new CountAgg();
    }

    public SlotAcc createSlotAcc(FacetContext fcontext, long numDocs, int numSlots) throws IOException {
        return new Acc(fcontext, numDocs, numSlots, this.inner.createSlotAcc(fcontext, numDocs, numSlots));
    }

    public int hashCode() {
        return 0;
    }

    public String description() {
        return "debug()";
    }

    public FacetMerger createFacetMerger(Object prototype) {
        return this.inner.createFacetMerger(prototype);
    }

    public static class DebugAggNumShards
    extends AggValueSource {
        public DebugAggNumShards() {
            super("debugNumShards");
        }

        public SlotAcc createSlotAcc(FacetContext fcontext, long numDocs, int numSlots) {
            return new NumShardsAcc(fcontext, numDocs, numSlots);
        }

        public int hashCode() {
            return 0;
        }

        public String description() {
            return "debug(numShards)";
        }

        public FacetMerger createFacetMerger(Object prototype) {
            return new FacetModule.FacetLongMerger();
        }

        public static class NumShardsAcc
        extends SlotAcc {
            public NumShardsAcc(FacetContext fcontext, long numDocs, int numSlots) {
                super(fcontext);
            }

            public void collect(int doc, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            }

            public int compare(int slotA, int slotB) {
                return 0;
            }

            public Object getValue(int slotNum) throws IOException {
                return 1L;
            }

            public void reset() throws IOException {
            }

            public void resize(SlotAcc.Resizer resizer) {
            }
        }
    }

    public static class Acc
    extends SlotAcc {
        public static AtomicLong creates = new AtomicLong(0L);
        public static AtomicLong resets = new AtomicLong(0L);
        public static AtomicLong resizes = new AtomicLong(0L);
        public static AtomicLong collectDocs = new AtomicLong(0L);
        public static AtomicLong collectDocSets = new AtomicLong(0L);
        public static Acc last;
        public SlotAcc sub;
        public long numDocs;
        public int numSlots;

        public Acc(FacetContext fcontext, long numDocs, int numSlots, SlotAcc sub) {
            super(fcontext);
            last = this;
            this.numDocs = numDocs;
            this.numSlots = numSlots;
            this.sub = sub;
            creates.addAndGet(1L);
        }

        public void collect(int doc, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            collectDocs.addAndGet(1L);
            this.sub.collect(doc, slot, slotContext);
        }

        public int collect(DocSet docs, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            collectDocSets.addAndGet(1L);
            return this.sub.collect(docs, slot, slotContext);
        }

        public int compare(int slotA, int slotB) {
            return this.sub.compare(slotA, slotB);
        }

        public Object getValue(int slotNum) throws IOException {
            return this.sub.getValue(slotNum);
        }

        public void reset() throws IOException {
            resets.addAndGet(1L);
            this.sub.reset();
        }

        protected void resetIterators() throws IOException {
            this.sub.resetIterators();
        }

        public void resize(SlotAcc.Resizer resizer) {
            resizes.addAndGet(1L);
            this.numSlots = resizer.getNewSize();
            this.sub.resize(resizer);
        }

        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            this.sub.setNextReader(readerContext);
        }

        public void setValues(SimpleOrderedMap<Object> bucket, int slotNum) throws IOException {
            this.sub.key = this.key;
            this.sub.setValues(bucket, slotNum);
        }

        public void close() throws IOException {
            this.sub.close();
        }
    }

    public static class Parser
    extends ValueSourceParser {
        public ValueSource parse(FunctionQParser fp) throws SyntaxError {
            String what;
            parses.incrementAndGet();
            switch (what = fp.hasMoreArguments() ? fp.parseId() : "wrap") {
                case "wrap": {
                    return new DebugAgg(fp);
                }
                case "numShards": {
                    return new DebugAggNumShards();
                }
            }
            throw new RuntimeException("No idea what to do with " + what);
        }
    }
}

